/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp.comm.rsp;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.rsp.BDdfResponse;

/**
 * This class is used as the response to a BDdfHttpInspectPingRequest.
 * 
 * @author    Lenard Perkins
 * @creation  01 Jan 08
 * @version   $Revision$ $Date: 02/19/2009 3:42:00 PM$
 * @since     Baja 1.0
 */
public class BDdfHttpInspectPingResponse
  extends BDdfResponse
{
  /*-
    class BDdfHttpInspectPingResponse
    {
    }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfHttp.comm.rsp.BDdfHttpInspectPingResponse(3986497183)1.0$ @*/
/* Generated Fri Feb 22 14:52:47 EST 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfHttpInspectPingResponse.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BDdfHttpInspectPingResponse()
  {
    
  }
  
  public BDdfHttpInspectPingResponse(IDdfDataFrame httpResponseData, String urlAddress)
  {
    // Since this is just a device status ping request, then by default,
    // the mere fact that we received a response means that the device
    // is online. Therefore, no further processing is required by default
    
    // This grabs a reference to the urlAddress string of the request and
    // a copy of the http response bytes, in case a subclass needs access
    // to these
    
    this.urlAddress = urlAddress;
    byte httpResponseBytes[] = new byte[ httpResponseData.getFrameSize() ];
    
    // Copies the bytes from the httpResponseData to a local safe copy
    System.arraycopy( httpResponseData.getFrameBytes(),
                      0,
                      httpResponseBytes,
                      0,
                      httpResponseData.getFrameSize() );
    
    // Stores the copy of the bytes from the httpResponseData inside a String
    // on the instance.
    this.htmlText = new String(httpResponseBytes);
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
 
  protected String htmlText;
  protected String urlAddress;

}
