/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp.comm.req;

import javax.baja.security.BICredentials;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.req.BIDdfRequest;

/**
 * Any HTTP request that requires a special user name or password,
 * that is, a user name or password other than that which can be
 * specified at runtime on the HTTP communicator, then the request
 * may implement this interface in order to specify the user name
 * and password for the request.
 *
 * @author    Lenard Perkins
 * @creation  01 Jan 08
 * @version   $Revision$ $Date: 02/19/2009 3:42:00 PM$
 * @since     Baja 1.0
 */
public interface BIDdfHttpCredentialsReq
    extends BIDdfRequest
{
  
  /**
   * Specifies the user name an password for the request.
   * 
   * @return a BICredentials instance that specifies the user name
   * and password for the request.
   */
  public BICredentials getCredentials();
  
////////////////////////////////////////////////////////////////
//Type
////////////////////////////////////////////////////////////////

 public static final Type TYPE = Sys.loadType(BIDdfHttpStreamRequest.class);

}
