/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp.comm;

import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.IDdfFacetConst;

/**
 * This extends the javax.baja.security.BUsernameAndPassword simply to
 * add dev driver facets to the username and password fields.
 * 
 * @author    Lenard Perkins
 * @creation  01 Jan 08
 * @version   $Revision$ $Date: 02/19/2009 3:42:00 PM$
 * @since     Baja 1.0
 */
public class BDdfHttpUserNameAndPassword
  extends BUsernameAndPassword
  implements IDdfFacetConst
{
  /*-
    class BDdfHttpUserNameAndPassword
    {
      properties
      {
        username: String
          -- Adds MGR_INCLUDE and MGR_OPTIONAL_IN_TABLE to the username field to allow it to show up in the edit dialog of the Ddf Device Manager
          default {[ BString.DEFAULT ]}
          slotfacets {[ DdfFacets.combine(MGR_INCLUDE, MGR_OPTIONAL_IN_TABLE) ]}
        password: BPassword
          -- Adds MGR_INCLUDE and MGR_OPTIONAL_IN_TABLE to the password field to allow it to show up in the edit dialog of the Ddf Device Manager
          default {[ BPassword.DEFAULT ]}
          slotfacets {[ DdfFacets.combine(MGR_INCLUDE, MGR_OPTIONAL_IN_TABLE) ]}
      }
    }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfHttp.comm.BDdfHttpUserNameAndPassword(1461153793)1.0$ @*/
/* Generated Fri Mar 28 08:19:43 EDT 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "username"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>username</code> property.
   * Adds MGR_INCLUDE and MGR_OPTIONAL_IN_TABLE to the username field to allow it to show up in the edit dialog of the Ddf Device Manager
   * @see com.tridium.ddfHttp.comm.BDdfHttpUserNameAndPassword#getUsername
   * @see com.tridium.ddfHttp.comm.BDdfHttpUserNameAndPassword#setUsername
   */
  public static final Property username = newProperty(0, BString.DEFAULT,DdfFacets.combine(MGR_INCLUDE, MGR_OPTIONAL_IN_TABLE));
  
  /**
   * Get the <code>username</code> property.
   * @see com.tridium.ddfHttp.comm.BDdfHttpUserNameAndPassword#username
   */
  public String getUsername() { return getString(username); }
  
  /**
   * Set the <code>username</code> property.
   * @see com.tridium.ddfHttp.comm.BDdfHttpUserNameAndPassword#username
   */
  public void setUsername(String v) { setString(username,v,null); }

////////////////////////////////////////////////////////////////
// Property "password"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>password</code> property.
   * Adds MGR_INCLUDE and MGR_OPTIONAL_IN_TABLE to the password field to allow it to show up in the edit dialog of the Ddf Device Manager
   * @see com.tridium.ddfHttp.comm.BDdfHttpUserNameAndPassword#getPassword
   * @see com.tridium.ddfHttp.comm.BDdfHttpUserNameAndPassword#setPassword
   */
  public static final Property password = newProperty(0, BPassword.DEFAULT,DdfFacets.combine(MGR_INCLUDE, MGR_OPTIONAL_IN_TABLE));
  
  /**
   * Get the <code>password</code> property.
   * @see com.tridium.ddfHttp.comm.BDdfHttpUserNameAndPassword#password
   */
  public BPassword getPassword() { return (BPassword)get(password); }
  
  /**
   * Set the <code>password</code> property.
   * @see com.tridium.ddfHttp.comm.BDdfHttpUserNameAndPassword#password
   */
  public void setPassword(BPassword v) { set(password,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfHttpUserNameAndPassword.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/ 
  
  public String toString(Context context)
  {
    return "[ "+getUsername() + " / ... ]";
  }  

}
