/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp;

import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.BDdfCommNetwork;
import com.tridium.ddfHttp.comm.BDdfHttpCommunicator;

/**
 * This is the override point for drivers whose device components communicate indirectly to the
 * corresponding field-device through a web server.
 * 
 * In other words, this is used as the base class for driver networks when the field-devices are not
 * the web server itself but instead are located behind a web server that provides some sort of
 * access to the field-devices over an HTTP protocol.
 * 
 * @author    Lenard Perkins
 * @creation  01 Jan 08
 * @version   $Revision$ $Date: 02/19/2009 3:42:00 PM$
 * @since     Baja 1.0
 */
public abstract class BDdfHttpGatewayNetwork
    extends BDdfCommNetwork
{
  /*-
    class BDdfHttpGatewayNetwork
    {
      properties
      {
        communicator : BValue
          -- Uses a BDdfHttpCommunicator for communication.
          default{[ new BDdfHttpCommunicator() ]}
      }
    }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfHttp.BDdfHttpGatewayNetwork(3703808889)1.0$ @*/
/* Generated Fri Feb 22 14:52:47 EST 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "communicator"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>communicator</code> property.
   * Uses a BDdfHttpCommunicator for communication.
   * @see com.tridium.ddfHttp.BDdfHttpGatewayNetwork#getCommunicator
   * @see com.tridium.ddfHttp.BDdfHttpGatewayNetwork#setCommunicator
   */
  public static final Property communicator = newProperty(0, new BDdfHttpCommunicator(),null);
  
  /**
   * Get the <code>communicator</code> property.
   * @see com.tridium.ddfHttp.BDdfHttpGatewayNetwork#communicator
   */
  public BValue getCommunicator() { return get(communicator); }
  
  /**
   * Set the <code>communicator</code> property.
   * @see com.tridium.ddfHttp.BDdfHttpGatewayNetwork#communicator
   */
  public void setCommunicator(BValue v) { set(communicator,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfHttpGatewayNetwork.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
