/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp;

import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.BDdfCommDevice;
import com.tridium.ddfHttp.comm.BDdfHttpCommunicator;

/**
 * This is the base class for driver device components that communicate
 * directly to a webserver.
 * 
 * In other words, this is the base class to be used when a driver's field-devices
 * are themselves web servers.
 * 
 * @author    Lenard Perkins
 * @creation  01 Jan 08
 * @version   $Revision$ $Date: 02/19/2009 3:42:00 PM$
 * @since     Baja 1.0
 *
 */
public class BDdfHttpDevice
    extends BDdfCommDevice
{
  /*-
   class BDdfHttpDevice
   {
     properties
     {
       communicator : BValue
         -- Uses a BDdfHttpCommunicator for communication.
         default{[ new BDdfHttpCommunicator() ]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfHttp.BDdfHttpDevice(642687153)1.0$ @*/
/* Generated Fri Feb 22 14:52:47 EST 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "communicator"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>communicator</code> property.
   * Uses a BDdfHttpCommunicator for communication.
   * @see com.tridium.ddfHttp.BDdfHttpDevice#getCommunicator
   * @see com.tridium.ddfHttp.BDdfHttpDevice#setCommunicator
   */
  public static final Property communicator = newProperty(0, new BDdfHttpCommunicator(),null);
  
  /**
   * Get the <code>communicator</code> property.
   * @see com.tridium.ddfHttp.BDdfHttpDevice#communicator
   */
  public BValue getCommunicator() { return get(communicator); }
  
  /**
   * Set the <code>communicator</code> property.
   * @see com.tridium.ddfHttp.BDdfHttpDevice#communicator
   */
  public void setCommunicator(BValue v) { set(communicator,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfHttpDevice.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
