/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.ui.point;

import javax.baja.driver.ui.point.PointState;
import javax.baja.workbench.mgr.BAbstractManager;

import com.tridium.ddf.ui.DdfMgrStateUtil;

/**
 * Preserves the Ddf Point Manager's state if the user temporarily
 * navigates away.
 * 
 * @author lperkins
 *
 */
public class DdfPointState
  extends PointState
{

////////////////////////////////////////////////////////////////
// PointState
////////////////////////////////////////////////////////////////
   
  protected void restoreForType(BAbstractManager manager)
  {
    super.restoreForType(manager);
    
    if (manager instanceof BDdfPointManager)
      DdfMgrStateUtil.restoreState((BDdfPointManager)manager);
  }

  protected void saveForType(BAbstractManager manager)
  {
    super.saveForType(manager);
    
    if (manager instanceof BDdfPointManager)
      DdfMgrStateUtil.saveState((BDdfPointManager)manager);
  }

}
