/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.ui.point;

import javax.baja.driver.ui.point.PointModel;
import javax.baja.workbench.mgr.MgrColumn;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.ui.DdfMgrModelUtil;

/**
 * This is the point model that is used for the Ddf Point Manager.
 * 
 * For any Niagara AX manager, the point model essentially defines
 * the behavior and characteristics of the database pane.
 * 
 * This class uses introspection and special facets to automatically
 * generate the database pane so that the developer does not have
 * to define any UI classes.
 * 
 * @see com.tridium.ddf.ui.DdfMgrModelUtil.makeColumns
 * 
 * @author lperkins
 *
 */
public class DdfPointModel
  extends PointModel
  implements IDdfFacetConst
{
  public DdfPointModel(BDdfPointManager manager)
  {
    super(manager);
  }
  
////////////////////////////////////////////////////////////////
// PointModel
////////////////////////////////////////////////////////////////
  
  /**
   * Automatically determines the MgrColumns for the database list.
   */
  protected MgrColumn[] makeColumns()
  {
    return DdfMgrModelUtil.makeColumns(getManager());
  }
}
