/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.ui.point;

import javax.baja.driver.ui.point.BPointManager;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.BDdfPointDeviceExt;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.ui.DdfMgrLearn;
import com.tridium.ddf.ui.DdfMgrUtil;

/**
 * The BDdfPointManager is a registered Niagara AX agent on
 * BDdfPointDeviceExt and BDdfPointFolder. It automatically
 * appears on them as one of their a Niagara AX 'Views'.
 *
 * This provides a fully-functional point manager for drivers
 * that are built on the devDriver framework. This uses introspection
 * plus the rest of the ddf to make this happen.
 *
 * @author lperkins
 *
 */
public class BDdfPointManager
  extends BPointManager
  implements IDdfFacetConst
{
  /*-
   class BDdfPointManager
   {
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.ui.point.BDdfPointManager(625718671)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfPointManager.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BPointManager
////////////////////////////////////////////////////////////////
  
  /**
   * Plugs an DdfPointModel into the standard Niagara AX mgr framework.
   */
  protected MgrModel makeModel()
  {
    return new DdfPointModel(this);
  }
  
  /**
   * Plugs an DdfMgrLearn into the standard Niagara AX mgr framework.
   */
  protected MgrLearn makeLearn()
  {
    Type discoveryLeafType = DdfMgrUtil.getDiscoveryLeafType(this);
    
    if (discoveryLeafType==null) // If the discovery host does not define a discovery leaf type
      return null;
    else
      return new DdfMgrLearn(this);

  }
  /**
   * Plugs an DdfPointController into the standard Niagara AX mgr framework.
   */
  protected MgrController makeController()
  {
    return new DdfPointController(this);
  }
  
  /**
   * Plugs an DdfPointState into the standard Niagara mgr framework.
   */
  protected MgrState makeState()
  {
    return new DdfPointState();
  }

////////////////////////////////////////////////////////////////
// BAbstractManager
////////////////////////////////////////////////////////////////
  
  /**
   * Customizes the doLoadValue method.
   *
   * Possibly updates the DdfMgrLearn with a set of cached discovery object
   * from the manager's ddf discovery host's discovery folder.
   *
   * Calls DdfMgrUtil.doLoadManager
   *
   * @see DdfMgrUtil.doLoadManager
   */
  public void doLoadValue(BObject obj, Context cx)
  {
    super.doLoadValue(obj,cx);
    DdfMgrUtil.doLoadManager(this);
  }

////////////////////////////////////////////////////////////////
// BDdfPointManager
////////////////////////////////////////////////////////////////
  
  /**
   * Gets the corresponding BDdfDevice for this device manager.
   */
  public BDdfDevice getDdfDevice()
  {
    return DdfMgrUtil.findDdfDevice(this);
  }
  
  /**
   * Gets the corresponding BDdfPointDeviceExt for this device manager.
   */
  public BDdfPointDeviceExt getDdfPointDeviceExt()
  {
    return DdfMgrUtil.findDdfPointDeviceExt(this);
  }
}
