/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.ui.device;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;

import com.tridium.ddf.BDdfNetwork;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.ui.DdfMgrControllerUtil.DdfDeviceMgrAgentCommand;

public interface BIDdfDeviceMgrAgent
  extends BInterface, IDdfFacetConst
{
  /**
   * This name can be either just a name or a lexicon key that defines the button text and the
   * optional button label.
   */
  public String getUiName();
  
  /**
   * This method is called when the user clicks the
   * corresponding button on the device manager for this
   * agent.The developer may define any functionality
   * here.
   * 
   * NOTE: This will execute on the client-side proxy's
   * virtual machine. Any access to the server-side
   * host will therefore have to be through properties,
   * actions, etc.
   * 
   * @param a reference to the device manager
   * @param a reference to the network that the device manager is
   * operating upon
   * 
   * @return an undo/redo command artifact or null
   */
  public CommandArtifact doInvoke(BDdfDeviceManager deviceManager, BDdfNetwork network);
  
  /**
   * This method is called when the ddf device manager
   * is created. It allows the developer to specify the MGR_CONTROLLER flags
   * that govern whether a button, menu item, toolbar item, etc. is created
   * for this agent.
   * 
   * @return
   */
  public int getFlags();
  
  /**
   * The developer should review the given BDdfDeviceManager and consider
   * updating (eg. enable/disable) the given agentCommand and/or any other
   * commands on the manager's controller. The method is called anytime
   * there is a change of state on the device manager (eg. discovery list
   * selection change, database list selection change, database component
   * event, learn mode changed, etc.)
   * 
   * For example (to enable the agent's UI widget(s) if one database item is selected):
   *  agentCommand.setEnabled(deviceManager.getController().getSelectedRows().length == 1);
   *  
   * For example (to enable the agent's UI widget(s) if one or more database items are selected):
   *  agentCommand.setEnabled(deviceManager.getController().getSelectedRows().length > 0);
   *  
   * For example (to enable the agent's UI widget(s) if zero database items are selected):
   *  agentCommand.setEnabled(deviceManager.getController().getSelectedRows().length == 0);
   *   
   * @param deviceManager
   * 
   * @param agentCommand this is a special instance of IMgrCommand. It is
   * a reference to the corresponding GUI command (button, menu item, and/or
   * toolbar button) on the device manager.
   */
  public void update(BDdfDeviceManager deviceManager, DdfDeviceMgrAgentCommand agentCommand);
  
  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  public static final Type TYPE = Sys.loadType(BIDdfDeviceMgrAgent.class);    
}
