/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.ui.device;

import javax.baja.sys.BStruct;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.MgrController;

import com.tridium.ddf.ui.DdfMgrControllerUtil.DdfDeviceMgrAgentCommand;

/**
 * The developer may extend this class and declare their type
 * as an agent on their network. This will add a button, menu
 * item, and/or toolbar item to the corresponding ddf device
 * manager.
 * 
 * When the ui item is clicked, the doInvoke method on an instance
 * of this class will be called on the client-side.
 */
public abstract class BDdfDeviceMgrAgent
  extends BStruct
  implements BIDdfDeviceMgrAgent
{
  /*-
  class BDdfDeviceMgrAgent
  {
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.ui.device.BDdfDeviceMgrAgent(3104471343)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfDeviceMgrAgent.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BIDdfDeviceMgrAgent - Default Implementations
////////////////////////////////////////////////////////////////
  
  /**
   * By default, the getFlags method returns MgrController.BARS
   * to make this BDdfDeviceMgrAgent appear in the menu bar, toolbar,
   * and button panel (action bar) of the ddf point manager or
   * ddf device manager.
   */
  public int getFlags()
  {
    return MgrController.BARS;
  }
  
  /**
   * The developer should review the given BDdfDeviceManager and consider
   * updating (eg. enable/disable) the given agentCommand and/or any other
   * commands on the manager's controller. The method is called anytime
   * there is a change of state on the device manager (eg. discovery list
   * selection change, database list selection change, database component
   * event, learn mode changed, etc.)
   * 
   * For example (to enable the agent's UI widget(s) if one database item is selected):
   *  agentCommand.setEnabled(deviceManager.getController().getSelectedRows().length == 1);
   *  
   * For example (to enable the agent's UI widget(s) if one or more database items are selected):
   *  agentCommand.setEnabled(deviceManager.getController().getSelectedRows().length > 0);
   *  
   * For example (to enable the agent's UI widget(s) if zero database items are selected):
   *  agentCommand.setEnabled(deviceManager.getController().getSelectedRows().length == 0);
   *   
   * @param deviceManager
   * 
   * @param agentCommand this is a special instance of IMgrCommand. It is
   * a reference to the corresponding GUI command (button, menu item, and/or
   * toolbar button) on the device manager.
   */
  public void update(BDdfDeviceManager deviceManager, DdfDeviceMgrAgentCommand agentCommand)
  {
    
  }
  
  
}
