/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.ui;

import java.util.Hashtable;

import javax.baja.naming.BOrd;
import javax.baja.sys.BajaException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.workbench.mgr.BAbstractManager;

public class DdfMgrStateUtil
{
  /**
   * This is a utility class that by default is not meant
   * to be instantiated.
   */
  protected DdfMgrStateUtil(){}
  
/////////////////////////////////////////////////////////////////////////
// Util
/////////////////////////////////////////////////////////////////////////
  
  /**
   * Called from DdfDeviceState or DdfPointState when a ddf manager is de-activated.
   */
  public static void saveState(BAbstractManager mgr)
  {
    if (mgr!=null)
      if (mgr.getLearn()!=null)
        if (mgr.getLearn().getJob()!=null)
          if (mgr.getLearn().getJob().getComponentSpace()!=null)
            saveState(DdfMgrUtil.findDiscoveryHost(mgr), mgr.getLearn().getJob().getNavOrd());
  }
  
  protected static void saveState(Object mgrHashKey, BOrd navOrdOfLastLearn)
  {
    if (mgrHashKey!=null)
      jobTable.put(mgrHashKey, navOrdOfLastLearn); // The navOrdOfLastLearn will allow us to restore the job if the manager is revisited
  }
  
  /**
   * Called from DdfDeviceState or DdfPointState when a ddf manager is re-activated.
   */
  public static void restoreState(BAbstractManager mgr)
  {
    if (mgr!=null)
      if (mgr.getLearn()!=null)
          restoreState(mgr, jobTable.get(DdfMgrUtil.findDiscoveryHost(mgr)));
  }
  
  protected static void restoreState(BAbstractManager mgr, BOrd navOrdOfLastLearn)
  { 
    try
    {
      if (navOrdOfLastLearn!=null)
        if (mgr.getLearn()!=null)
          mgr.getLearn().setJob(navOrdOfLastLearn);
    }
    catch (BajaException e)
    { 
      // This happens if the job has been cleaned up from the Job service.
      //System.out.println(DdfLexicon.ddfMgrJobExpired);
    }
    catch (BajaRuntimeException e)
    { 
      // This happens if the job has been cleaned up from the Job service.
      //System.out.println(DdfLexicon.ddfMgrJobExpired);
    }
    catch (Exception e)
    {
      throw new BajaRuntimeException(e);
    }
  }  
  
/////////////////////////////////////////////////////////////////////////
// Attributes
/////////////////////////////////////////////////////////////////////////
  protected static Hashtable<Object, BOrd> jobTable = new Hashtable<>();
  
}