/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.ui;

import javax.baja.control.BControlPoint;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.sys.BComponent;
import javax.baja.nre.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;

import com.tridium.ddf.IDdfFacetConst;

public class DdfMgrModelUtil
  implements IDdfFacetConst
{
  /**
   * Cannot instantiate! Access static methods only.
   */
  protected DdfMgrModelUtil(){}

/////////////////////////////////////////////////////////////////////////
//Util
/////////////////////////////////////////////////////////////////////////

  /**
   * Introspects recursively through the properties of the database type and returns
   * an array of MgrColumn objects for all BSimples, that have the MGR_INCLUDE facet,
   * anywhere recursively under the database type. It recurses under BComplex properties
   * if they have the MGR_INCLUDE facet.
   */
  public static MgrColumn[] makeColumns(BAbstractManager mgr)
  {
    Array<MgrColumn> mgrColumns = new Array<>(MgrColumn.class);

    BComponent databaseInstanceDefault = DdfMgrUtil.getDatabaseInstanceDefault(mgr);

    // Always adds an MgColumn.Path
    mgrColumns.add(
        new MgrColumn.Path(
            MgrColumn.UNSEEN));           // The Workbench Mgr framework implicitly requires this

    // Always adds an MgrColumn.Name
    mgrColumns.add(new MgrColumn.Name()); // The Workbench Mgr framework implicitly requires this

    // Always ddds an MgrColumn.Type
    mgrColumns.add(new MgrColumn.Type()); // The Workbench Mgr framework implicitly requires this

    // Always adds a DeviceExtsColumn to the device manager
    if (mgr instanceof BDeviceManager)    // If the model is for a device manager
    {
      mgrColumns.add(                     //   Then this adds a column to allow ddf
          new DeviceExtsColumn(           //   Navigation to the Niagara AX device extensions
              (BDevice)databaseInstanceDefault));
    }

    // Always adds a "facets", and "out" column to the point manager
    else if (mgr instanceof BPointManager)// Else if the model is for a point manager
    {
      mgrColumns.add(
          new DdfMgrColumnUtil.DdfMgrProp(BControlPoint.facets, MgrColumn.EDITABLE|MgrColumn.UNSEEN));

      mgrColumns.add(                     //   Then this ads a column to summarize
          new MgrColumn.ToString(         //   The point's output
              Lexicon.make(
                  BPointManager.class).
                  getText("out"), 0));
    }

    // Adds MgrColumn objects for all BSimple properties with the MGR_INCLUDE facet, that are
    // Found either below the database prototype or below a BComplex with the MGR_INCLUDE facet
    // That is below the database prototype.
    mgrColumns.addAll(                    // Adds MgrColumn objects's for all
        DdfMgrColumnUtil.getColumnsFor(  // BSimple and 'summary' BStruct props that are directly
            databaseInstanceDefault));    // Under (and possibly recursively under) the sample database object.

    return mgrColumns.trim();
  }
}
