/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.ui;

import java.util.ArrayList;

import javax.baja.driver.ui.point.PointModel;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrTypeInfo;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.discover.BIDdfDiscoveryLeaf;

/**
 * Provides the functionality that is common between the ddf device learn and
 * the ddf point learn.
 * 
 * @author lperkins
 *
 */
public class DdfMgrLearnUtil
  implements IDdfFacetConst
{
  /**
   * Cannot instantiate! Access static methods only.
   */
  protected DdfMgrLearnUtil(){}

/////////////////////////////////////////////////////////////////////////
// Util
/////////////////////////////////////////////////////////////////////////
  
  /**
   * Makes the columns for the learn aspect of a ddf workbench manager.
   * This is accomplished by introspecting the discovery object type and
   * making the MgrColumn array accordingly.
   */
  public static MgrColumn[] makeColumns(BAbstractManager mgr)
  {

    BIDdfDiscoveryLeaf defaultDiscoveryObject = DdfMgrUtil.getDiscoveryLeafInstance(mgr);
    
    MgrColumn[] mgrCols = DdfMgrColumnUtil.getColumnsFor((BComplex)defaultDiscoveryObject);
    
    if (mgrCols==null || mgrCols.length==0)
    {
      throw new IllegalStateException(DdfUiLexicon.discoveryLeafNeedsMgrIncludeFacets(defaultDiscoveryObject));
    }
    else
      return mgrCols;
  }

  /**
   * Given a discovery row object, return a list of the types
   * which may be used to model it as a BComponent in the
   * station database.  This method is used by the add command.
   * The type at index 0 in the array should be the type which
   * provides the best mapping.  Return an empty array if the
   * discovery cannot be mapped.
   */
  public static MgrTypeInfo[] toTypes(Object discovery)
  {
    if (discovery instanceof BIDdfDiscoveryLeaf)
    {
      BIDdfDiscoveryLeaf discoveryLeaf = (BIDdfDiscoveryLeaf)discovery;
      
      TypeInfo[] validDbTypes = discoveryLeaf.getValidDatabaseTypes();
      
      // Gets the valid database types, if the driver developer specified them (if not, we'll allow all point types)
      if (validDbTypes!=null && validDbTypes.length>0) 
        return MgrTypeInfo.makeArray(validDbTypes);
      //else, the logic falls through to the bottom
    }

    //else, the logic falls through to the bottom
    // Builds a list of all valid types
    ArrayList<MgrTypeInfo> allTypes = new ArrayList<>();
    
    PointModel.addNumericPointTypes(allTypes, true);
    PointModel.addBooleanPointTypes(allTypes, true);
    PointModel.addStringPointTypes(allTypes, true);
    PointModel.addEnumPointTypes(allTypes, true);
    
    // Returns an array of all valid control point types.
    return allTypes.toArray(
        new MgrTypeInfo[allTypes.size()]);
  }
}
