/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.poll;

import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.IDdfFacetConst;

/**
 * The BDdfPollScheduler uses this class to wrap a BIDdfPollable
 * before passing it to the BDdfPollScheduler's super.subscribe
 * method. This allows BIDdfPollables to not have to be BIPollable
 * (and therefore BIDdfPollables do not have to declare pollFrequency).
 *
 * This attempts to make it easy on driver developers so that if they
 * don't declare a poll frequency then everything will still work.
 *
 * @author lperkins
 */
public class BDdfPollableWrapper
  extends BObject
    implements BIPollable, IDdfFacetConst
{
  /*-
   class BDdfPollableWrapper
   {
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.poll.BDdfPollableWrapper(1545335160)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfPollableWrapper.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Constructor - BDdfPollableWrapper - used by BDdfPollScheduler
   *
   * @param the BIDdfPollable that this object will wrap
   */
  BDdfPollableWrapper(BIDdfPollable wrapped)
  {
    this.wrappedDdfPollable=wrapped;
  }
  
////////////////////////////////////////////////////////////////
// BIPollable  
////////////////////////////////////////////////////////////////
  /**
   * Returns the poll frequency of the wrapped ddf pollable or BPollFrequency.slow if the
   * wrapped, ddf pollable does not implement the getPollFrequency method.
   */
  public BPollFrequency getPollFrequency()
  {
    if (wrappedDdfPollable instanceof BIPollable)
      return ((BIPollable) wrappedDdfPollable).getPollFrequency();
    else
      return BPollFrequency.slow;
  }

////////////////////////////////////////////////////////////////
// Attributes  
////////////////////////////////////////////////////////////////
  BIDdfPollable wrappedDdfPollable;
}
