/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.poll;

import java.util.Hashtable;

import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.req.BIDdfReadRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;

/**
 * This is the default poll scheduler for the developer driver
 * framework.
 *
 * @author lperkins
 */
public class BDdfPollScheduler
  extends BPollScheduler
  implements BIDdfPollScheduler
{
  /*-
   class BDdfPollScheduler
   {
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.poll.BDdfPollScheduler(608611433)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfPollScheduler.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
//BDdfPollScheduler API
////////////////////////////////////////////////////////////////
 
 protected void doPoll(BIDdfPollable ddfPollable)
  {
    BIDdfReadRequest ddfPollRequest = ddfPollable.makePollRequest();

    // Asks the ddf pollable's ddf communicator to ddfCommunicate the ddfPollable's poll request
    DdfRequestUtil.communicateSync(ddfPollable.getDdfCommunicator(), ddfPollRequest); // Blocks until the request is
                                                                                      // completely processed, timed
                                                                                      // out, or an interrupted
                                                                                      // exception occurs
  }

  /**
   * Had to make this default access since this method was added after the release devDriver. This maintains API
   * stability.
   * 
   * @return
   */
  boolean isStartable()
  {
    // Looks up the ancestry for the first device or network and
    // Keys off of its status
    BComponent parent = (BComponent) getParent();

    while (parent != null)
    {
      if (parent instanceof BDevice)
        return !(((BDevice) parent).isDisabled() || ((BDevice) parent).isFault());
      else if (parent instanceof BDeviceNetwork)
        return !(((BDeviceNetwork) parent).isDisabled() || ((BDeviceNetwork) parent).isFault());
      else
        parent = (BComponent) parent.getParent();
    }

    // If the logic makes it this far then this transaction mgr is not
    // a nav node that is anywhere under a device or a network. This is
    // not a valid use scenario.
    return true;
  }

////////////////////////////////////////////////////////////////
// BIDdfPollScheduler
////////////////////////////////////////////////////////////////
  
  /**
   * Registers a BIDdfPollable to this ddf poll scheduler.
   */
  public void subscribe(BIDdfPollable ddfPollableValue)
  { 
    // We need to get or make a wrapper for the given BIDdfPollable
    // I use the wrapper because the super class requires a BIPollable (which
    // has a poll frequency) and I don't want to require that BIDdfPollables
    // have a poll frequency). I'd like to keep BIDdfPollables free from having
    // this requirement, since I anticipate future support for virtual points,
    // which are not proxies, and might not naturally feature the ability to
    // add a pollFrequency (one requirement of BIPollable)
    BDdfPollableWrapper wrapper=null;
    
    synchronized(wrappers)
    { 
      // Attempts to get previously created wrapper for the given BIDdfPollable
      wrapper = wrappers.get(ddfPollableValue);
      
      if (wrapper == null) // If not found
      { 
        // Makes a wrapper for the given BIDdfPollable
        wrapper = new BDdfPollableWrapper(ddfPollableValue);
        
        wrappers.put(ddfPollableValue, wrapper); // Remembers the wrapper in case the given BIDdfPollable is resubscribed or unsubscribed
      }
    }
    
    // Subscribes the wrapper on behalf of the given BIDdfPollable
    super.subscribe(wrapper);
  }
  
  public void unsubscribe(BIDdfPollable ddfPollableValue)
  { 
    // Gets the wrapper object for the given ddfPollableValue
    BDdfPollableWrapper wrapper=null;
    
    synchronized(wrappers)
    {
      wrapper = wrappers.get(ddfPollableValue);
      
      if (wrapper == null)
        return;
    }
    
    // Unsubscribes the wrapper object
    super.unsubscribe(wrapper);
  }
  
////////////////////////////////////////////////////////////////
// BPollScheduler
////////////////////////////////////////////////////////////////

  /**
   * @throws IllegalAccessError if called! Please use the ddfSubscribe method instead.
   */
  public void subscribe(BIPollable p)
  {
    throw new IllegalAccessError("Use ddfSubscribe instead.");
  }
  
  /**
   * @throws IllegalAccessError if called! Please use the ddfUnsubscribe method instead.
   */
  public boolean unsubscribe(BIPollable p)
  {
    throw new IllegalAccessError("Use ddfUnsubscribe instead.");
  }
  
  /**
   * This method is called by BPollScheduler when its time to poll the given BIPollable. We know
   * that the given BIPollable is an instance of BDdfPollableWrapper because that's how we designed
   * the ddfSubscribe to work.
   */
  public final void doPoll(BIPollable p) throws Exception
  { 
    if (isStartable())
    {
      // Casts 'p' into a BDdfPollableWrapper
      BDdfPollableWrapper ddfPollableWrapper = (BDdfPollableWrapper)p;
      
      // Gets the BIDdfPollable wrapped in the BDdfPollableWrapper
      BIDdfPollable ddfPollable = ddfPollableWrapper.wrappedDdfPollable;
      
      // Calls doPoll but passes teh BIDdfPollable instead.
      doPoll(ddfPollable);
    }
    else
    {
      Thread.sleep(1000);
    }
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  // Remembers the wrapper object used for BIDdfPollable. I use wrappers as a layer of insulation against
  // The user's implementation of BIDdfPollable
  Hashtable<BIDdfPollable, BDdfPollableWrapper> wrappers = new Hashtable<>();
  
}
