/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.point;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfWriteRequest;
import com.tridium.ddf.comm.req.IDdfWritable;


/**
 * Driver components that are writable should implement this interface.
 *
 * If your driver provides a proxy extension that extends BDdfProxyExt then
 * you probably do not need to implement this directly.
 *
 * @author lperkins
 */
public interface BIDdfWritable
  extends BInterface, IDdfWritable
{

  public Type getWriteRequestType();

  /**
   * Indicates the BDdfCommunicator that will send and/or receive field-bus messages for this object. This
   * could vary widely based on the communication medium. For serial drivers, the ddf communicator object is
   * usually placed on the ddf network. For tcp driver, the ddf communicator object is typically placed on
   * the ddf network if the network acts as a gateway, or on the ddf device if the field device has its own
   * i.p. address.
   */
  public BIDdfCommunicator getDdfCommunicator();
  
  /**
   * Instances need to construct an instance of BIDdfWriteRequest to be placed on the ddf
   * communicator. The ddf communicator will make 'transmit' the serialized data from this
   * BIDdfWriteRequest onto the field-bus and make call-backs to this BIDdfWriteRequest object
   * when the response is receive or timed out.
   */
  public BIDdfWriteRequest makeWriteRequest();
  
  /**
   * Instances need to construct an instance of BIDdfWriteRequest to be placed on the ddf
   * communicator, if they wish to have a special version of the write request transmitted whenever
   * the point is "auto'ed" from within Niagara. The ddf communicator will  'transmit' the serialized
   * data from this BIDdfWriteRequest onto the field-bus and make call-backs to this BIDdfWriteRequest object
   * when the response is receive or timed out.
   *
   * If not special handling is desired when points are "auto'ed" then this method can return null or
   * empty array.
   */
  public BIDdfWriteRequest makeAutoRequest();

  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfWritable.class);
}
