/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.identify;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.IDdfFacetConst;

/**
 * This is fundamental to developer driver framework's auto-poll and auto-discovery
 * features.
 *
 * The driver developer should:
 *
 * 1.) Define a class that extends BDdfIdParams and implements this interface
 * (or that extends the corresponding BDdfReadParams for convenience).
 *
 * 2.) Define a proxy ext class that extends BDdfProxyExt, if a suitable
 * one is not already defined.
 *
 * 3.) Define a request class that extends BDdfRequest and implements
 * BIDdfReadRequest (or that extends BDdfReadRequest for convenience).
 *
 * 4.) Re-define the readParameters property on the request created in step
 * three and make the default value be an instance of the class that
 * implements this interface.
 *
 * 5.) Re-define the readParameters property on the proxy ext created in step
 * two and make the default value be an instance of the class that
 * implements this interface.
 *
 * =========================================================
 * To read the value of a control point in a device in a
 * driver that is built on the ddf, the
 * ddf:
 *
 * 1.)Calls getReadParameters on the proxy extension.
 * (getReadParameters returns an instance of this interface)
 *
 * 2.)Calls getReadRequestType on the instance of this
 * interface that it received in step 1.
 *
 * 3.)Instantiates an instance of the read request class
 * that corresponds to the read request type that the
 * ddf received in step 2.
 *
 * 4.)Calls setReadParameters on the read request and passes
 * in a copy of what it received back in step 1.
 *
 * 5.)Calls setPointId on the read request and passes in a
 * copy of the BDdfIdParams object that the proxy's
 * getPointId method returns.
 *
 * 6.)Calls setDeviceId on the read request and passes in a
 * copy of the BDdfIdParams object that the proxy's
 * device's getDeviceId method returns.
 *
 * @author lperkins
 *
 * @see BDdfReadParams
 * @see com.tridium.ddf.comm.req.BDdfReadRequest
 * @see com.tridium.ddf.comm.req.BIDdfReadRequest
 * @see com.tridium.ddf.point.BDdfProxyExt
 *
 */
public interface BIDdfReadParams
  extends BInterface, IDdfFacetConst
{
  /**
   * The implementing class needs to return the type that represents
   * the ddf read requests from the driver whose requestId can
   * be an instance of the implementing class.
   *
   * This is fundamental to developer driver framework's auto-poll feature.
   *
   * @return review method description.
   */
  public Type getReadRequestType();

  /**
   * The implementing class needs to return one or more Types that
   * represent the ddf read requests from the driver whose requestId can
   * be an instance of the implementing class.
   *
   * We recommend that you return an array of size one with the one item
   * being the same type as the return of the getDdfReadRequestType method.
   *
   * This is fundamental to developer driver framework's auto-discovery feature.
   *
   * @return review method description.
   */
  public Type[] getReadRequestTypes();

  /**
   * The developer needs to implement this method and return true if
   * the given instance of BIDdfReadParams would read the same exact
   * item or items as the current instance of BIDdfReadParams. This
   * allows the ddf to 'poll' multiple points from the same driver
   * protocol request in one communication transaction.
   *
   * @param anotherProxyReadParams
   *
   * @return true if the given BIDdfReadParams represents the same
   * communication transaction as the current instance of BIDdfReadParams.
   */
  public boolean groupWith(BIDdfReadParams anotherProxyReadParams);

  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfReadParams.class);
}
