/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.identify;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.IDdfFacetConst;

/**
 * This is fundamental to developer driver framework's auto-ping and auto-discovery
 * features.
 *
 * The driver developer should:
 *
 * 1.) Define a class that extends BDdfIdParams and implements this interface
 * (or that extends the corresponding BDdfPingParams for convenience).
 *
 * 2.) Define a device class that extends BDdfDevice, if a suitable
 * one is not already defined.
 *
 * 3.) Define a request class that extends BDdfRequest and implements
 * BIDdfPingRequest (or that extends BDdfPingRequest for convenience).
 *
 * 4.) Re-define the deviceId property on the request created in step
 * three and make the default value be an instance of the class that
 * implements this interface.
 *
 * 5.) Re-define the deviceId property on the device created in step
 * two and make the default value be an instance of the class that
 * implements this interface.
 *
 * ======================================================================
 * To ping a device in a driver that is built on the developer
 * driver framework, the ddf:
 *
 * 1.)Calls getPingParameters on the device.
 * (getPingParameters returns an instance of this interface)
 *
 * 2.)Calls getPingRequestType on the instance of this
 * interface that it received in step 1.
 *
 * 3.)Instantiates an instance of the ping request class
 * that corresponds to the ping request type that the
 * ddf received in step 2.
 *
 * 4.)Calls setPingParameters on the ping request and passes
 * in a copy of what it received back in step 1.
 *
 * 5.)Calls setDeviceId on the ping request and passes in a
 * copy of the BDdfIdParams object that the device's getDeviceId
 * method returns.
 *
 * @author lperkins
 *
 * @see BDdfPingParams
 * @see com.tridium.ddf.comm.req.BDdfPingRequest
 * @see com.tridium.ddf.comm.req.BIDdfPingRequest
 * @see com.tridium.ddf.BDdfDevice
 */
public interface BIDdfPingParams
  extends BInterface, IDdfFacetConst
{
  /**
   * The implementing class needs to return a Type that represents
   * the ping message from the driver whose deviceId can be an
   * instance of this object's class. If the class supports more than
   * one ping request type, then this should return the type that is
   * the most appropriate for the particular instance of the implementing
   * class.
   *
   * This is fundamental to developer driver framework's auto-discovery and auto-ping
   * features.
   *
   * @return review method description.
   */
  public Type getPingRequestType();
  /**
   * This method is included for future extensibility. We recommend
   * that the developer return an array of size one, with the one item
   * being the same Type that is returned by the getDdfPingRequestType
   * method.
   *
   * This method is used in the driver's auto-discovery feature. It allows
   * the auto-discovery mechanism to transmit multiple different ping messsages
   * for the same hypothetical device it. We envision that the
   * multiple flavors of ping messages might be used for different sub-device
   * types.
   *
   * @return review method description.
   */
  public Type[] getPingRequestTypes();

  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfPingParams.class);
}
