/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.identify;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * This class is a convenience for developers who wish
 * to define a set of read parameters. To read the value
 * of a control point in a device in a driver that is
 * built on the ddf:
 *
 * 1.)Calls getReadParameters on the proxy extension.
 * (getReadParameters returns an instance of this class)
 *
 * 2.)Calls getReadRequestType on the instance of this
 * class that it received in step 1.
 *
 * 3.)Instantiates an instance of the read request class
 * that corresponds to the read request type that the
 * ddf received in step 2.
 *
 * 4.)Calls setReadParameters on the read request and passes
 * in a copy of what it received back in step 1.
 *
 * 5.)Calls setPointId on the read request and passes in a
 * copy of the BDdfIdParams object that the proxy's
 * getPointId method returns.
 *
 * 6.)Calls setDeviceId on the read request and passes in a
 * copy of the BDdfIdParams object that the proxy's
 * device's getDeviceId method returns.
 *
 * @see BIDdfPingParams
 *
 * @author lperkins
 */
public abstract class BDdfReadParams
  extends BDdfIdParams
  implements BIDdfReadParams
{
  /*-
   class BDdfReadParams
   {
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.identify.BDdfReadParams(2704152909)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfReadParams.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
////////////////////////////////////////////////////////////////
// BIDdfReadParams
////////////////////////////////////////////////////////////////
  
  
  public Type[] getReadRequestTypes()
  {
    return new Type[]{getReadRequestType()};
  }
  
  /**
   * The developer needs to implement this method and return true if
   * the given instance of BIDdfReadParams would read the same exact
   * item or items as the current instance of BIDdfReadParams. This
   * allows the ddf to 'poll' multiple points from the same driver
   * protocol request in one communication transaction.
   *
   * @param anotherProxyReadParams
   *
   * @return this default implementation returns true if the other
   * read parameters object is 'equivalent' to this read parameters
   * objects. The Niagara AX 'equivalent' method returns true if
   * both are the same type and all corresponding Niagara AX
   * property values are equal.
   */
  public boolean groupWith(BIDdfReadParams anotherProxyReadParams)
  {
    BDdfReadParams otherReadParams = (BDdfReadParams)anotherProxyReadParams;
    
    return otherReadParams.equivalent(this);
  }

}
