/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.discover.auto;

import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

import com.tridium.ddf.identify.BDdfIdParams;

/**
 * This class contains methods and attributes that help clean up other areas
 * of the source code that are used to display localized text.
 * 
 * @author lperkins
 */
public class DdfAutoDiscoveryLexicon
{
  public static final Lexicon LEX = Lexicon.make(DdfAutoDiscoveryLexicon.class);
  
  public static final String NO_DEVICES_FOUND="NoDevicesFound";
  
  public static final String noDevicesFound = LEX.getText(NO_DEVICES_FOUND);
  
  public static final String DEVICE_NOT_FOUND="DeviceNotFound";
  
  public static String deviceNotFound(BDdfIdParams deviceId)
  {
    return LEX.getText(DEVICE_NOT_FOUND, new Object[]{deviceId});
  }
  
  public static final String NO_POINTS_FOUND="NoPointsFound";
  
  public static final String noPointsFound = LEX.getText(NO_POINTS_FOUND);
  
  public static final String POINT_NOT_FOUND="PointNotFound";
  
  public static String pointsNotFound(BDdfIdParams readRequestId)
  {
    return LEX.getText(POINT_NOT_FOUND, new Object[]{readRequestId});
  }
  
  
  // This message is placed in the error log and standard output if during an
  // auto-discovery, it is discovered that the ping request or read request
  // does not implement BIDiscoverRequest. The text passed to parameter {0} is
  // the name of the offending Type.
  // TypeMustImplementDiscoveryRequest = The type must implement BIDdfDiscoveryRequest since it is being used in auto-discovery. Type = {0}
  public static final String TYPE_MUST_IMPLEMENT_DISCOVERY_REQUEST = "TypeMustImplementDiscoveryRequest";
  
  public static String typeMustImplementDiscoveryRequest(Type badType){
    return LEX.getText(TYPE_MUST_IMPLEMENT_DISCOVERY_REQUEST, new Object[]{badType});
  }
  
  
}
