/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.discover;

import javax.baja.driver.point.BProxyConversion;
import javax.baja.sys.BFacets;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Discovery leaves that appear in the Ddf Point Manager should
 * implement this interface.
 *
 * These methods allow the driver developer to customize the
 * initial values of driver proxy extensions as driver control
 * points are added to the station from the Ddf Point Manager.
 *
 * @author lperkins
 *
 */
public interface BIDdfPointDiscoveryLeaf
  extends BIDdfDiscoveryLeaf
{

  /**
   * When a control point is added to the station from the Ddf
   * Point Manager, a copy of the value that this method returns
   * is assigned to the deviceFacets property of the control point.
   *
   * You may return null if you do not wish to assign a value
   * to the deviceFacets property.
   */
  public BFacets getDiscoveryDeviceFacets();
  /**
   * When a control point is added to the station from the Ddf
   * Point Manager, a copy of the value that this method returns
   * is assigned to the facets property of the control point.
   *
   * You may return null if you do not wish to assign a value
   * to the pointFacets property.
   */
  public BFacets getDiscoveryPointFacets();
  /**
   * When a control point is added to the station from the Ddf
   * Point Manager, a copy of the value that this method returns
   * is assigned to the conversion property of the control
   * point's proxy extension.
   *
   * You may return null if you do not wish to assign a value
   * to the discoveryConversion property.
   */
  public BProxyConversion getDiscoveryConversion();
  /**
   * When a control point is added to the station from the Ddf
   * Point Manager, a copy of the value that this method returns
   * is assigned to the tuningPolicyName property of the control
   * point's proxy extension.
   *
   * You may return null if you do not wish to assign a value
   * to the tuningPolicyName property.
   */
  public String getDiscoveryTuningPolicyName();
  
  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfPointDiscoveryLeaf.class);
}
