/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.discover;

import javax.baja.naming.BOrd;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

import com.tridium.ddf.comm.BIDdfCommunicating;
import com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences;

/**
 * Parent components built on the ddf that
 * have a user interface manager associated with them (the
 * Ddf Device Manager and Ddf Point Manager are examples
 * of user interface managers) and whose user interface
 * managers providessupport for a discovery (in other words,
 * a "Discover" button) should implement this interface.
 *
 * The BDdfCommNetwork and BDdfPointDeviceExtension
 * extension implement this interface.
 *
 * @author lperkins
 *
 */
public interface BIDdfDiscoveryHost
  extends BIDdfCommunicating
{

  /**
   * This is a getter for an Action called submitDiscoveryJob that
   * takes an instance of BDdfAutoDiscoveryPreferences and returns
   * a BOrd to the job that is running in the station.
   */
  public BOrd submitDiscoveryJob(BDdfAutoDiscoveryPreferences discoveryParams);
  
  /**
   * This is a getter for a Property called discoverPreferences
   * that returns an instance of BDdfAutoDiscoveryPreferences
   *
   * @return a copy of the most recent ddf auto discovery job preferences
   */
  public BDdfDiscoveryPreferences getDiscoveryPreferences();

  /**
   * If descendants wish to store or persist discovery objects in the
   * database, then they should add a property to the discovery host's
   * slotomatic statement named "discoveryFolder" of type BFolder.
   *
   * The resulting boiler-plate code for the "discoveryFolder" property
   * will include a getDiscoveryFolder method that satisfies this
   * interface.
   *
   * Alternatively, descendants can return null to have the discovery
   * objects stored transiently as children of the discovery job.
   */
  public BFolder getDiscoveryFolder();

  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfDiscoveryHost.class);
}
