/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.discover;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.identify.BDdfIdParams;

/**
 * BIDdfDeviceDiscoveryLeaf objects define both, the deviceId and pingParameters
 * of a device. Driver developers may return an array of BIDdfDeviceDiscoveryLeaf
 * objects from their driver's BIDdfDiscoveryResponse class that is associated with
 * their device's discoverId.
 * 
 * NOTE: If driver developers do not wish to initialize or update both the deviceId
 * and pingParameters of new database devices (when the end-user clicks "Add" from
 * the Device Manager) then they may return an array of their device id class or and
 * array of their ping- parameters class from their driver's BIDdfDiscoveryResponse
 * class that is associated with their device's discoverId.1 
 * 
 * @author lperkins
 */
public interface BIDdfDeviceDiscoveryLeaf
  extends BIDdfDiscoveryObject
{
  public BDdfIdParams getDeviceId();
  
  public BDdfIdParams getPingParameters();

  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfDeviceDiscoveryLeaf.class);    
}
