/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.discover;

import javax.baja.driver.point.BProxyConversion;
import javax.baja.sys.BFacets;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.identify.BDdfIdParams;

/**
 * Driver developers should extend this class and redefine the
 * default values of the pointId, readParameters, and writeParameters
 * and make them return instances that are the same type as those on
 * their driver's proxy ext.
 * 
 * Then, driver developers should make their BIDdfDiscoverResponse.
 * parseDiscoveryObjects method return an array of BDdfPointDiscoveryLeaf
 * objects. They should set the pointId, readParameters, and writeParameters
 * of each BDdfPointDiscoveryLeaf accordingly (from within the parseDiscoveryObjects).
 * The values of the pointId, readParameters, and writeparameters will be
 * extracted from the data in the response.
 * 
 * @author lperkins
 *
 */
public abstract class BDdfPointDiscoveryLeaf
  extends BDdfDiscoveryLeaf
  implements BIDdfPointDiscoveryLeaf
{
  /*-
   class BDdfPointDiscoveryLeaf
   {
     properties
     {
       readParameters : BDdfIdParams
         default{[new BDdfIdParams()]}
       writeParameters : BDdfIdParams
         default{[new BDdfIdParams()]}
       pointId : BDdfIdParams
         default{[new BDdfIdParams()]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.discover.BDdfPointDiscoveryLeaf(2528100042)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "readParameters"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>readParameters</code> property.
   * @see com.tridium.ddf.discover.BDdfPointDiscoveryLeaf#getReadParameters
   * @see com.tridium.ddf.discover.BDdfPointDiscoveryLeaf#setReadParameters
   */
  public static final Property readParameters = newProperty(0, new BDdfIdParams(),null);
  
  /**
   * Get the <code>readParameters</code> property.
   * @see com.tridium.ddf.discover.BDdfPointDiscoveryLeaf#readParameters
   */
  public BDdfIdParams getReadParameters() { return (BDdfIdParams)get(readParameters); }
  
  /**
   * Set the <code>readParameters</code> property.
   * @see com.tridium.ddf.discover.BDdfPointDiscoveryLeaf#readParameters
   */
  public void setReadParameters(BDdfIdParams v) { set(readParameters,v,null); }

////////////////////////////////////////////////////////////////
// Property "writeParameters"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>writeParameters</code> property.
   * @see com.tridium.ddf.discover.BDdfPointDiscoveryLeaf#getWriteParameters
   * @see com.tridium.ddf.discover.BDdfPointDiscoveryLeaf#setWriteParameters
   */
  public static final Property writeParameters = newProperty(0, new BDdfIdParams(),null);
  
  /**
   * Get the <code>writeParameters</code> property.
   * @see com.tridium.ddf.discover.BDdfPointDiscoveryLeaf#writeParameters
   */
  public BDdfIdParams getWriteParameters() { return (BDdfIdParams)get(writeParameters); }
  
  /**
   * Set the <code>writeParameters</code> property.
   * @see com.tridium.ddf.discover.BDdfPointDiscoveryLeaf#writeParameters
   */
  public void setWriteParameters(BDdfIdParams v) { set(writeParameters,v,null); }

////////////////////////////////////////////////////////////////
// Property "pointId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pointId</code> property.
   * @see com.tridium.ddf.discover.BDdfPointDiscoveryLeaf#getPointId
   * @see com.tridium.ddf.discover.BDdfPointDiscoveryLeaf#setPointId
   */
  public static final Property pointId = newProperty(0, new BDdfIdParams(),null);
  
  /**
   * Get the <code>pointId</code> property.
   * @see com.tridium.ddf.discover.BDdfPointDiscoveryLeaf#pointId
   */
  public BDdfIdParams getPointId() { return (BDdfIdParams)get(pointId); }
  
  /**
   * Set the <code>pointId</code> property.
   * @see com.tridium.ddf.discover.BDdfPointDiscoveryLeaf#pointId
   */
  public void setPointId(BDdfIdParams v) { set(pointId,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfPointDiscoveryLeaf.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BIDdfPointDiscoveryLeaf
////////////////////////////////////////////////////////////////
  
  /**
   * Your driver can extends this class and override this method
   * to customize the proxy conversion for learned points.
   */
  public BProxyConversion getDiscoveryConversion()
  {
    return null;
  }

  /**
   * Your driver can extends this class and override this method
   * to customize the device facets for learned points.
   */
  public BFacets getDiscoveryDeviceFacets()
  {
    return null;
  }

  /**
   * Your driver can extends this class and override this method
   * to customize the point facets for learned points.
   */
  public BFacets getDiscoveryPointFacets()
  {
    return null;
  }

  /**
   * Your driver can extends this class and override this method
   * to customize the tuning policy name for learned points.
   */
  public String getDiscoveryTuningPolicyName()
  {
    return null;
  }  
}
