/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.discover;

import javax.baja.registry.TypeInfo;
import javax.baja.sys.BStruct;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Discovery leaves appear in the discovery list on the
 * Ddf Device Manager or Ddf PointManager. Ddf discovery
 * leaves are not exapandable in the discovery list. They
 * do not have any child entries under themselves.
 *
 * @author    lperkins
 * @creation  Oct 25, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BDdfDiscoveryLeaf
  extends BStruct
  implements BIDdfDiscoveryLeaf
{
  /*-
   class BDdfDiscoveryLeaf
   {

   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.discover.BDdfDiscoveryLeaf(392069481)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfDiscoveryLeaf.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
//BIDdfDiscoveryLeaf
////////////////////////////////////////////////////////////////
    
  /**
   * Descendants need to return an array of TypeInfo objects corresponding to all valid Niagara Ax types for this discovery object.
   * This is important when the end-user clicks 'Add' from the user interface for the manager.
   *
   * For this discovery object, please  return a list of the types
   * which may be used to model it as a BComponent in the
   * station database.
   *
   * The type at index 0 in the array should be the type which
   * provides the best mapping.  Please return an empty array if the
   * discovery cannot be mapped.
   */
  public TypeInfo[] getValidDatabaseTypes()
  {
    return null;
  }

  /**
   * Descendants need to return the default name that a discovery object's
   * database component should be named when adding it to the station.
   */
  public String getDiscoveryName()
  {
    return null;
  }


}
