/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.discover;

import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * This is the default implementation of BIDdfDiscoveryGroup
 * 
 * @see BIDdfDiscoveryGroup
 * 
 * Your BIDdfDiscoverResponse.parseDiscoveryObjects's return array may
 * contain instances of this class. Each instance of this class contains
 * one or more BDdfDiscoveryGroups or BDdfDiscoveryLeafs
 * 
 * @author lperkins
 *
 */
public class BDdfDiscoveryGroup
  extends BVector
  implements BIDdfDiscoveryGroup
{
  /*-
  class BDdfDiscoveryGroup
  {
    properties
    {
      description : String
        default{["DiscoveryGroup"]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.discover.BDdfDiscoveryGroup(1091036731)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "description"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>description</code> property.
   * @see com.tridium.ddf.discover.BDdfDiscoveryGroup#getDescription
   * @see com.tridium.ddf.discover.BDdfDiscoveryGroup#setDescription
   */
  public static final Property description = newProperty(0, "DiscoveryGroup",null);
  
  /**
   * Get the <code>description</code> property.
   * @see com.tridium.ddf.discover.BDdfDiscoveryGroup#description
   */
  public String getDescription() { return getString(description); }
  
  /**
   * Set the <code>description</code> property.
   * @see com.tridium.ddf.discover.BDdfDiscoveryGroup#description
   */
  public void setDescription(String v) { setString(description,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfDiscoveryGroup.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  /**
   * Gets the discovery leaves that are under this group.
   */
  public BIDdfDiscoveryLeaf[] getDiscoveryLeaves()
  {
    return getChildren(BIDdfDiscoveryLeaf.class);
  }
  /**
   * Gets the discovery groups that are under this group.
   * @return
   */
  public BIDdfDiscoveryGroup[] getDiscoveryGroups()
  {
    return getChildren(BIDdfDiscoveryGroup.class);
  }
  
  
  public String toString(Context cx)
  {
    return getDescription();
  }
}
