/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.singleTransaction;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.BIDdfTransactionMgr;
/**
 * BIDdfSingleTransactionMgr classes that would implement BIDdfTransactionMgr
 * but only allow single outstanding messages on the fieldbus at a time should implement this
 * interface instead. This interface extends BIDdfTransactionMgr but does nothing
 * else, other than document the fact that the transaction manager only allows single
 * outstanding requests at a time.
 *
 * @author    lperkins
 * @creation  Oct 18, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public interface BIDdfSingleTransactionMgr
    extends BIDdfTransactionMgr
{
  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfSingleTransactionMgr.class);
}
