/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddf.comm.rsp;

/**
 * A DdfResponseException may implement this method. If so, the DDF
 * will call the 'getBytes()' method and transmit the corresponding
 * bytes upon catching this while processing the received data frames
 * for a request.
 * 
 * @author lperkins
 *
 */
public interface IDdfTransmitAckResponse
{
  /**
   * The BDdfTransactionManager calls this method if it
   * receives a BIDdfTransmitAckResponse for any outstanding
   * or expired request. If this method returns a byte array
   * that is not null then the ddf transaction manager will
   * ask the ddf communicator to immediately transmit the
   * resulting bytes, ahead of any requests that might be
   * in the communicator's queue.
   */
  public byte[] getBytes();
}
