/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.req.util;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BIDdfDiscoverRequest;
import com.tridium.ddf.comm.rsp.BIDdfDiscoverResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.discover.IDdfDiscoverer;

/**
 * Processes discovery requests on behalf of the transaction
 * manager.
 * 
 * @author lperkins
 */
public class DdfDiscoveryRequestUtil
  implements IDdfFacetConst
{
////////////////////////////////////////////////////////////////
// Util
////////////////////////////////////////////////////////////////
  
  public static void processResponse(BIDdfDiscoverRequest discoverReq, BIDdfDiscoverResponse discoverRsp)
  {
    IDdfDiscoverer discoverer = discoverReq.getDiscoverer();
    
    if (discoverer!=null)
      discoverer.discoverOk(
          discoverRsp.parseDiscoveryObjects(
              discoverer.getDiscoverContext()));
  }
  
  public static void processTimeout(BIDdfDiscoverRequest discoverReq)
  {
    IDdfDiscoverer discoverer = discoverReq.getDiscoverer();
    
    if (discoverer!=null)
      discoverer.discoverFail(DdfDefaultCommLexicon.requestTimeOut);
  }
  
  public static void processLateResponse(BIDdfDiscoverRequest discoverReq, BIDdfDiscoverResponse discoverRsp)
  {
    IDdfDiscoverer discoverer = discoverReq.getDiscoverer();
    
    if (discoverer!=null)
      discoverer.discoverOk(
        discoverRsp.parseDiscoveryObjects(
            discoverer.getDiscoverContext()));
  }
  
  public static void processErrorResponse(BIDdfDiscoverRequest discoverReq, DdfResponseException errorRsp)
  {
    IDdfDiscoverer discoverer = discoverReq.getDiscoverer();
    
    if (discoverer!=null)
      discoverer.discoverFail(DdfDefaultCommLexicon.responseError(errorRsp));
  }
}
