/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.req;

import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.identify.BDdfIdParams;

/**
 * IDdfWritable is the interface that developer driver BValue's implement if they are
 * writable (such as some proxy ext's) that extend from the Niagara Ax Developer Driver Framework.
 *
 * @author    lperkins
 * @creation  Oct 9, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public interface IDdfWritable
  extends IDdfFacetConst
{
  public BFacets getFacets();
  
  public BStatusValue getWriteValue();
  
  public BDdfIdParams getPointId();
  
  public BDdfIdParams getWriteParameters();
  
  public void writeOk(BStatusValue out);
  
  public void writeFail(String reason);
}
