/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.req;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.identify.BDdfIdParams;

/**
 * Drivers should create a class that implements this interface for each
 * message in their driver's protocol that is capable of updating a value
 * or setting a data value in some field equipment.
 *
 * @author lperkins
 */
public interface BIDdfWriteRequest
  extends BIDdfRequest
{
  /**
   * Indicates whether multiple IDdfWritables's with the
   * same writeParams, under the same device, should be
   * automatically grouped (coalesced) into the same write request.
   *
   * In other words, if an attempt is ever made to write multiple IDdfWritables
   * at about the same time, then they will all be written
   * using the same write request.
   */
  public boolean isGroupable();
  /**
   * Gets the write parameters that distinguish one instance
   * of the request class from another instance, in addition
   * to the deviceId that BIDdfRequest already provides.
   *
   * @return
   */
  public BDdfIdParams getWriteParameters();
  /**
   * Sets the write parameters that distinguish one instance
   * of the request class from another instance, in addition
   * to the deviceId that BIDdfRequest already provides.
   */
  public void setWriteParameters(BDdfIdParams requestId);
  /**
   * Returns the writableSource objects that this message can
   * update. The ddf will automatically call
   * writeOk or writeFail on these items.
   */
  public IDdfWritable[] getWritableSource();

  /**
   * Assigns the writableSource objects that this message can
   * update. If the message only reads one
   * item then the array may be of length one!
   *
   * This method is also called automatically in the
   * com.tridium.ddf framework to automatically
   * write points in drivers that are based on the ddf driver
   * framework.
   */
  public void setWritableSource(IDdfWritable[] writableSource);


  /**
   * If set to true then the ddf will automatically
   * call writeOk on all writable source objects whenever a response is
   * received for this request.
   */
  public boolean getAutoWriteOk();

  /**
   * If set to true then the ddf will automatically
   * call writeOk on all writable source objects in the event that the
   * response to this message is received late after this request times
   * out. This behavior is sometimes desireable for protocols that support
   * multiple outstanding requests.
   */
  public boolean getAutoWriteOkLate();

  /**
   * If set to true then the ddf will automatically
   * call writeFail on all writable source objects in the event that the
   * a timeout occurs while waiting for the response to this message.
   */
  public boolean getAutoWriteFailOnTimeout();

  /**
   * If this method returns true then the ddf driver
   * framework will call writeFail on all readable sources
   * for this request upon receipt of a response that
   * indicates an error condition.
   */
  public boolean getAutoWriteFailOnError();
  
  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfWriteRequest.class);

}
