/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.req;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.discover.IDdfDiscoverer;
import com.tridium.ddf.identify.BDdfIdParams;

/**
 * Requests such as ping requests and read requests should consider
 * implementing this interface as well. This is a fundamental part
 * of the auto-discovery feature.
 *
 * When the end user clicks the "Discover" button:
 *
 * 1. The Developer Driver Manager view will kick off a BDdfAutoDiscoveryJob in the station.
 * 2. The job will be passed an instance of BDdfAutoDiscoveryPreferences.
 * 3. The job will loop from the BDdfAutoDiscoveryPreferences.getMin to its .getMax
 * 4. The job will place an instance of this interface onto the ddf communicator.
 * 5. <b>The type of the instance placed on the communicator will be
 *    BDdfDiscoveryPreferences.getMin().getDdfDiscoverRequestType(). It will pass
 *    the incremental discoveryParameters (as it the auto discovery job loops
 *    from BDdfAutoDiscoveryPreferences.getMin to its .getMax) and the deviceId 
 *    to the instance.</b>
 *
 *
 * @author lperkins
 *
 */

public interface BIDdfDiscoverRequest
  extends BIDdfRequest
{

  /**
   * Gets the discover parameters, these identify
   * extra information the particular request needs
   * in order to construct its byte array, etc.
   */
  public BDdfIdParams getDiscoverParameters();
  /**
   * Sets the discover parameters, these identify
   * extra information the particular request needs
   * in order to construct its byte array, etc.
   */
  public void setDiscoverParameters(BDdfIdParams discoverParams);
  
  /**
   * This passes an instance of <i>IDdfDiscoverer</i> to the request. The
   * implementing class may use the <i>IDdfdiscoverer</I> to gain access
   * to the BJob that is performing the discovery. This is an advanced
   * feature. Not all drivers will need to use this feature.
   * 
   * In any event, regardless of whether the developer wishes to use the
   * given instance of IDdfDiscoverer, it is essential that the implementing
   * class store the reference away and return the same reference from the
   * <i>getDiscoverer</i> method.
   * 
   * @param discoverer This passes an instance of <i>IDdfDiscoverer</i> to the request. The
   * implementing class may use the <i>IDdfdiscoverer</I> to gain access
   * to the BJob that is performing the discovery. This is an advanced
   * feature. Not all drivers will need to use this feature. In any event, regardless of
   * whether the developer wishes to use the given instance of IDdfDiscoverer, it is
   * essential that the implementing class store the reference away and return the same
   * reference from the <i>getDiscoverer</i> method.
   */
  public void setDiscoverer(IDdfDiscoverer discoverer);
  
  /**
   * It is very important that the implementing class simply return the
   * IDdfDiscoverer that was most recently passed to the <i>setDiscoverer</i>
   * method.
   * 
   * @return It is very important that the implementing class simply return the
   * IDdfDiscoverer that was most recently passed to the <i>setDiscoverer</i>
   * method.
   * 
   */
  public IDdfDiscoverer getDiscoverer();

  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  public static final Type TYPE = Sys.loadType(BIDdfDiscoverRequest.class);
}
