/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.req;

import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.identify.BIDdfWriteParams;
import com.tridium.ddf.point.BDdfProxyExt;

/**
 * This is the default base class that implements BIDdfWriteRequest.
 * 
 * The <i>toByteArray</i> method will need implemented in the descendant
 * class. During the automatic writing mechanism that is provided by
 * BDdfProxyExt, the <i>writeParameters</i> property is automatically
 * set to a copy of the <i>writeParameters</i> from the instance of
 * the proxy extension. Likewise the <i>deviceId</i> property is automatically
 * set to a copy of the <i>deviceId</i> property of the device that owns
 * the driver's BDdfProxyExt.
 * 
 * The same mechanism also provides the <i>writable source array</i> that
 * is available to the <i>toByteArray</i> method by calling the <i>getWritableSource</i>
 * method.
 * 
 * The <i>writeParameters</i> value is used to coalesce (combine) multiple write
 * operations into a single protocol request. If the driver's protocol features
 * write requests where a single write request can modify the values for more
 * than one data point, then the driver's discovery mechanism should be implemented
 * such that it provides multiple discovery leaves, each with an equivalent copy
 * of 'writeParameters' but each should a different 'pointId'.
 * 
 * Then from the <i>toByteArray</i> method, the developer may loop through the
 * <i>writable source array</i> and build the serialized byte array accordingly.
 * The header of the serialized byte array will typically contain information
 * from the <i>writeParameters</i> property (which all <i>writable source</i>
 * objects happen to share a copy of). The data portion of the serialized byte
 * array will typically contain information identifying each <i>writable source</i>
 * object (i.e. driver data point) as well as the new value for each <i>writable
 * source</i> object (i.e driver data point)
 * 
 * For more details please see:
 * <ol>
 * <li>The Java Doc that is provided with BIDdfWriteRequest for
 * more details.
 * <li>The Java Doc and Baja Doc that are provided for the
 * <i>writeParameters</i> property on this class.
 * </ol>
 * 
 * @see BIDdfWriteRequest
 * 
 * @author lperkins
 */
public abstract class BDdfWriteRequest
  extends BDdfRequest
  implements BIDdfWriteRequest
{
  /*-
   class BDdfWriteRequest
   {
    properties
    {
      writeParameters : BDdfIdParams
        -- These are the writeParameters that are common to all points that the write
        -- request needs write. The ddf instantiates write
        -- requests automatically. Here is how: Whenever a driver point needs to be 
        -- written, the ddf looks at the point's write parameters and
        -- instantiates an instance of the write request type that is specified by
        -- the point's write parameters. It then sets the writes parameters on the new
        -- write request equal to the write parameters on the point. Then it calls the
        -- setWritableSource method on the new write request and passes in all other
        -- driver points under the same point device extension that have the equivalent
        -- writeParameters. This effectively places all driver points under the same
        -- device that share the same writeParameters into a single group for writing. This
        -- allows the values for all of the points under a device that have equivalent
        -- write parameters to be written using just one field-bus request.
        default{[new BDdfIdParams()]}
    }
   
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.req.BDdfWriteRequest(4058620474)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "writeParameters"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>writeParameters</code> property.
   * These are the writeParameters that are common to all
   * points that the write request needs write. The ddf
   * instantiates write requests automatically. Here is
   * how: Whenever a driver point needs to be written, the ddf looks at the point's write parameters and instantiates an instance of the write request type that is specified by the point's write parameters. It then sets the writes parameters on the new write request equal to the write parameters on the point. Then it calls the setWritableSource method on the new write request and passes in all other driver points under the same point device extension that have the equivalent writeParameters. This effectively places all driver points under the same device that share the same writeParameters into a single group for writing. This allows the values for all of the points under a device that have equivalent write parameters to be written using just one field-bus request.
   * @see com.tridium.ddf.comm.req.BDdfWriteRequest#getWriteParameters
   * @see com.tridium.ddf.comm.req.BDdfWriteRequest#setWriteParameters
   */
  public static final Property writeParameters = newProperty(0, new BDdfIdParams(),null);
  
  /**
   * Get the <code>writeParameters</code> property.
   * @see com.tridium.ddf.comm.req.BDdfWriteRequest#writeParameters
   */
  public BDdfIdParams getWriteParameters() { return (BDdfIdParams)get(writeParameters); }
  
  /**
   * Set the <code>writeParameters</code> property.
   * @see com.tridium.ddf.comm.req.BDdfWriteRequest#writeParameters
   */
  public void setWriteParameters(BDdfIdParams v) { set(writeParameters,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfWriteRequest.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * 
   */
  public BDdfWriteRequest()
  {
  }

  /**
   * @param responseTimeout
   * @param maxRetryCount
   * @param deviceId
   * @param writeParams
   */
  public BDdfWriteRequest(BRelTime responseTimeout, int maxRetryCount, BDdfIdParams deviceId, BIDdfWriteParams writeParams)
  {
    super(responseTimeout,maxRetryCount,deviceId);
    setWriteParameters((BDdfIdParams)((BDdfIdParams)writeParams).newCopy());
  }
  
  /**
   * @param responseTimeout
   * @param maxRetryCount
   * @param ddfProxyExt
   */
  public BDdfWriteRequest(BRelTime responseTimeout, int maxRetryCount, BDdfProxyExt ddfProxyExt)
  {
    this(responseTimeout,maxRetryCount,ddfProxyExt.getDdfDevice().getDeviceId(),(BIDdfWriteParams)ddfProxyExt.getWriteParameters());
    setWritableSource(new IDdfWritable[]{ddfProxyExt});
  }
  
  /**
   * @param deviceId
   * @param writeParams
   */
  public BDdfWriteRequest(BDdfIdParams deviceId, BIDdfWriteParams writeParams)
  {
    super(deviceId);
    setWriteParameters((BDdfIdParams)((BDdfIdParams)writeParams).newCopy());
  }
  
  /**
   * @param ddfProxyExt
   */
  public BDdfWriteRequest(BDdfProxyExt ddfProxyExt)
  {
    this(ddfProxyExt.getDdfDevice().getDeviceId(),(BIDdfWriteParams)ddfProxyExt.getWriteParameters());
    setWritableSource(new IDdfWritable[]{ddfProxyExt});
  }  

////////////////////////////////////////////////////////////////
// BIDdfWriteRequest
////////////////////////////////////////////////////////////////

  /**
   * By default, multiple IDdfWritables's with the
   * same writeParams, under the same device, should be
   * automatically coalesced into the same write request
   * if the write params structure has properties.
   * 
   * The philosophy here is that if the developer has
   * custom-defined any properties on the write params
   * then any two proxies (writables) that share the
   * same write parameters should be written in one
   * request.
   */
  public boolean isGroupable()
  {
    return (getWriteParameters().getPropertiesArray().length>0);
  }  
  
  /**
   * @return true
   */
  public boolean getAutoWriteFailOnTimeout()
  {
    return true;
  }
  
  /**
   * @return true
   */
  public boolean getAutoWriteFailOnError()
  {
    return true;
  }

  /**
   * @return true
   */
  public boolean getAutoWriteOk()
  {
    return true;
  }

  /**
   * @return true
   */
  public boolean getAutoWriteOkLate()
  {
    return true;
  }
  
  /**
   * @return the IDdfWritable[] that was most recently passed to the
   * <i>setWritableSource</i> method.
   */
  public IDdfWritable[] getWritableSource()
  {
    return writableSource;
  }
  
  /**
   * @param the IDdfWritable[] that will be returned from any subsequent
   * calls to the <i>getWritableSource</i> method.
   */
  public void setWritableSource(IDdfWritable[] writeableSource)
  {
    this.writableSource=writeableSource;
  }
  
////////////////////////////////////////////////////////////////
// BDdfWriteRequest
////////////////////////////////////////////////////////////////
  
  /**
   * Descendants may call this method while constructing the
   * toByteArray method and pass in any of their IDdfWritable
   * source objects to get a raw <i>double</i> for serializing.
   * 
   * @param ddfWritable
   * 
   * @return a raw double representation of the given ddfWritable's writeValue.
   */
  protected double getRawValue(IDdfWritable ddfWritable)
  {
    BStatusValue writeValue = ddfWritable.getWriteValue();
    if (writeValue instanceof BStatusNumeric)
      return (((BStatusNumeric)writeValue).getNumeric());
    else if (writeValue instanceof BStatusEnum)
      return ((BStatusEnum)writeValue).getEnum().getOrdinal();
    else if (writeValue instanceof BStatusBoolean)
      return ((BStatusBoolean)writeValue).getBoolean()?1:0;
    else if (writeValue instanceof BStatusString)
    {
      String s = ((BStatusString)writeValue).getValue();
      try
      { // First let's try to parse the string as if it is the string of a double
        return Double.parseDouble(s);
      }
      catch (NumberFormatException nfe1)
      {
        try
        { // Then let's try to parse the string as if it is the string of a long integer
          // Let's respect the "radix" facet if it is present or use 10 if it's not
          int radix = getWritableSource()[0].getFacets().geti(BFacets.RADIX,10);
          return (int)Long.parseLong(s,radix);
        }
        catch (NumberFormatException nfe2)
        {
          // Then let's try to parse the String as an enum ordinal
          BEnumRange range = (BEnumRange)getWritableSource()[0].getFacets().get(BFacets.RANGE,null);
          if (range!=null)
          {
            try
            {
              return range.tagToOrdinal(s);
            }
            catch (InvalidEnumException iee)
            { // Falls through
            }
          }
          // After that, let's try to parse as a boolean value
          String trueText = getWritableSource()[0].getFacets().gets(BFacets.TRUE_TEXT,"True");
          if (s.equals(trueText))
          {
            return 1;
          }
          else
          {
            String falseText = getWritableSource()[0].getFacets().gets(BFacets.FALSE_TEXT,"False");
            if (s.equals(falseText))
              return 0;
            else
              throw new BajaRuntimeException(DdfDefaultCommLexicon.unsupportedStringFormat(getWritableSource()[0].toString(),s));
          }
        }
      }
    }
    // I thought I plugged all of the holes but I'm getting a compiler error saying that this method must return an int.
    // Therefore, I'm throwing an exception if the logic makes it this far -- just to make the compiler happy.
    throw new BajaRuntimeException(DdfDefaultCommLexicon.unsupportedStringFormat(getWritableSource()[0].toString(),getWritableSource()[0].getWriteValue().toString()));
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  private IDdfWritable[] writableSource = null;
  
}
