/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.req;

import javax.baja.sys.BRelTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.identify.BIDdfReadParams;
import com.tridium.ddf.point.BDdfProxyExt;


/**
 * This is a default, base class that implements BIDdfReadRequest.
 *
 * The <i>toByteArray</i> method will need implemented in the descendant
 * class. During the automatic reading/polling mechanism that is provided by
 * BDdfProxyExt, the <i>readParameters</i> property is automatically
 * set to a copy of the <i>readParameters</i> from the instance of
 * the proxy extension. Likewise the <i>deviceId</i> property is automatically
 * set to a copy of the <i>deviceId</i> property of the device that owns
 * the driver's BDdfProxyExt.
 * 
 * The same mechanism also provides the <i>readable source array</i> that
 * is available to the <i>toByteArray</i> method by calling the <i>getReadableSource</i>
 * method.
 * 
 * <b>IMPORTANT:</b> The <i>readParameters</i> value is used to group multiple read
 * operations into a single protocol request. <i>If</i> the driver's protocol features
 * read requests where the response to a single read request can be used to retrieve
 * the values for more than one data point. To take advantage of this, the driver's
 * discovery mechanism (see BDdfPointDiscoveryLeaf, BDdfDiscoveryRequest, and
 * BDdfDiscoveryResponse) should be implemented such that it provides multiple discovery
 * leaves, each with an equivalent copy of 'readParameters' but each should define
 * a different 'pointId'. (The <i>readParameters</i> assigns data points to an instance
 * of a protocol request. The <i>pointId</i> allows the driver to parse the retrieved
 * value from the corresponding protocol response)
 * 
 * Therefore, from the <i>toByteArray</i> method, the developer should only need to
 * access the <i>readParameters</i> and <i>deviceId</i> values that are readily available 
 * by calling <i>getReadParameters()</i> and <i>getDeviceId()</i> and casting the return
 * value to an instance of the driver's <i>device id class</i> and <i>read parameters
 * class </i>.
 * 
 * One might feel the need to ask, <i>how do I access the data point then</i>. However,
 * please keep in mind that as the previous two paragraphs attempt to describe, there
 * is not necessarily just one data point for the request. Even in the case where a
 * protocol features a simple request whose response returns a single data point value,
 * the Niagara AX station database could conceivably contain multiple copies of the same
 * data point. (Nothing usually prevents the end-user or integrator from adding a 
 * discovered point more than once). In this case, each data point that is created from
 * the same discovery leaf will have an equivalent copy of the same <i>readParameters</i>
 * structure. Each will all share a copy of the same <i>pointId</i> (or have no <i>pointId</i>
 * at all -- depending on how simple the protocol is. For these reasons, it would not make
 * sense to try to access the data points directly from the <i>toByteArray</i> method.
 * Instead, all data that would be required by the <i>toByteArray</i> method needs to be
 * stored in the <i>readParameters</i> structure.
 * 
 * The previous paragraph indicates that the driver should not be designed to require 
 * access to the <i>pointId</i> structure from the proxy extension(s) in the 
 * <i>toByteArray</i> method. Please note, however, in the event where the driver's
 * response to the protocol request truly can retrieve multiple values, then the 
 * <i>parseReadValue</i> method of the corresponding <i>BIDdfReadResponse</i> has
 * readily available access to the <i>pointId</i> since the <i>parseReadValue</i>
 * is called once for each proxy ext that is grouped together (sharing equivalent copies
 * of the same <i>readParameters</i>). The <i>parseReadValue</i> method is passed
 * a direct reference to the proxy ext (cast as IDdfReadable). In this scenarion, the
 * aforementioned proxies will all have an equivalent copy of the same <i>readParameters</i>.
 * However, each proxy's <i>pointId</i> will differ to allow the <i>parseReadValue</i>
 * method of the <i>BIDdfReadResponse</i> to retrieve the value for the particular
 * proxy.
 *
 * @see BIDdfReadRequest
 *
 * @author lperkins
 */
public abstract class BDdfReadRequest
  extends BDdfRequest
  implements BIDdfReadRequest
{
  /*-
  class BDdfReadRequest
  {
    properties
    {
      readParameters : BDdfIdParams
        -- These are the readParameters that are common to all points that the read
        -- request needs to retrieve. The ddf instantiates read
        -- requests automatically. Here is how: Whenever a driver point needs to be
        -- read, the ddf looks at the point's read parameters and
        -- instantiates an instance of the read request type that is specified by
        -- the point's read parameters. It then sets the read parameters on the new
        -- read request equal to the read parameters on the point. Then it calls the
        -- setReadableSource method on the new read request and passes in all other
        -- driver points under the same point device extension that have the equivalent
        -- readParameters. This effectively places all driver points under the same
        -- device that share the same readParameters into a single poll group. This
        -- allows the values for all of the points under a device that have equivalent
        -- read parameters to be retrieved in one field-bus request.
        --
        -- The ddf can also use read requests to automatically discover
        -- Readable data points. The point manager will prompt the user with a copy of the
        -- Discovery parameters as defined on your driver's ddf point device extension.
        -- Then it will look at the value that the end-user provides for the 'min' property.
        -- The value of the 'min' and 'max' properties must implement BIDdfReadParameters.
        -- The ddf will outer loop through each valid read request
        -- Type then it will inner loop from min to max, each pass through the inner loop
        -- the auto discovery framework will instantiate an instance of the read request
        -- type from the outer loop and pass in the read parameters from the inner loop.
        -- The auto-discovery process will transmit each request. It will then create
        -- Discovery objects for whatever requests that get valid responses.
        default{[new BDdfIdParams()]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.req.BDdfReadRequest(1168262585)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "readParameters"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>readParameters</code> property.
   * These are the readParameters that are common to all
   * points that the read request needs to retrieve. The
   * ddf instantiates read requests automatically. Here
   * is how: Whenever a driver point needs to be read, the ddf looks at the point's read parameters and instantiates an instance of the read request type that is specified by the point's read parameters. It then sets the read parameters on the new read request equal to the read parameters on the point. Then it calls the setReadableSource method on the new read request and passes in all other driver points under the same point device extension that have the equivalent readParameters. This effectively places all driver points under the same device that share the same readParameters into a single poll group. This allows the values for all of the points under a device that have equivalent read parameters to be retrieved in one field-bus request. The ddf can also use read requests to automatically discover Readable data points. The point manager will prompt the user with a copy of the Discovery parameters as defined on your driver's ddf point device extension. Then it will look at the value that the end-user provides for the 'min' property. The value of the 'min' and 'max' properties must implement BIDdfReadParameters. The ddf will outer loop through each valid read request Type then it will inner loop from min to max, each pass through the inner loop the auto discovery framework will instantiate an instance of the read request type from the outer loop and pass in the read parameters from the inner loop. The auto-discovery process will transmit each request. It will then create Discovery objects for whatever requests that get valid responses.
   * @see com.tridium.ddf.comm.req.BDdfReadRequest#getReadParameters
   * @see com.tridium.ddf.comm.req.BDdfReadRequest#setReadParameters
   */
  public static final Property readParameters = newProperty(0, new BDdfIdParams(),null);
  
  /**
   * Get the <code>readParameters</code> property.
   * @see com.tridium.ddf.comm.req.BDdfReadRequest#readParameters
   */
  public BDdfIdParams getReadParameters() { return (BDdfIdParams)get(readParameters); }
  
  /**
   * Set the <code>readParameters</code> property.
   * @see com.tridium.ddf.comm.req.BDdfReadRequest#readParameters
   */
  public void setReadParameters(BDdfIdParams v) { set(readParameters,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfReadRequest.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BDdfReadRequest()
  {
  }

  /**
   * @param responseTimeout
   * @param maxRetryCount
   * @param deviceId
   * @param readParams
   */
  public BDdfReadRequest(BRelTime responseTimeout, int maxRetryCount, BDdfIdParams deviceId, BIDdfReadParams readParams)
  {
    super(responseTimeout,maxRetryCount,deviceId);
    setReadParameters((BDdfIdParams)((BDdfIdParams)readParams).newCopy());
  }
  /**
   * @param responseTimeout
   * @param maxRetryCount
   * @param ddfProxyExt
   */
   public BDdfReadRequest(BRelTime responseTimeout, int maxRetryCount, BDdfProxyExt ddfProxyExt)
   {
     this(responseTimeout,maxRetryCount,ddfProxyExt.getDdfDevice().getDeviceId(),(BIDdfReadParams)ddfProxyExt.getReadParameters());
     setReadableSource(new IDdfReadable[]{ddfProxyExt});
   }

  /**
   * @param deviceId
   * @param readParams
   */
  public BDdfReadRequest(BDdfIdParams deviceId, BIDdfReadParams readParams)
  {
    super(deviceId);
    setReadParameters((BDdfIdParams)((BDdfIdParams)readParams).newCopy());
  }

  /**
   * @param ddfProxyExt
   */
  public BDdfReadRequest(BDdfProxyExt ddfProxyExt)
  {
    this(ddfProxyExt.getDdfDevice().getDeviceId(),(BIDdfReadParams)ddfProxyExt.getReadParameters());
    setReadableSource(new IDdfReadable[]{ddfProxyExt});
  }

////////////////////////////////////////////////////////////////
// BIDdfReadRequest
////////////////////////////////////////////////////////////////

  /**
   * @return true
   */
  public boolean getAutoReadFailOnTimeout()
  {
    return true;
  }
  /**
   * @return true
   */
  public boolean getAutoReadFailOnError()
  {
    return true;
  }

  /**
   * @return true
   */
  public boolean getAutoReadOk()
  {
    return true;
  }

  /**
   * @return true
   */
  public boolean getAutoReadOkLate()
  {
    return true;
  }
  
  /**
   * @param the IDdfReadable[] to return from subsequent calls to the
   * <i>getReadableSource</i> method.
   */
  public void setReadableSource(IDdfReadable[] readableSource)
  {
    this.readableSource=readableSource;
  }
  
  /**
   * @return the IDdfReadable[] that was most recently passed to the
   * <i>getReadableSource</i> method.
   */
  public IDdfReadable[] getReadableSource()
  {
    return readableSource;
  }
  
////////////////////////////////////////////////////////////////
// BDdfReadRequest
////////////////////////////////////////////////////////////////
  /**
   * By default, multiple IDdfReadable's with the
   * same readParams, under the same device, should be
   * automatically grouped into the same poll group **if
   * the readParams structure has any properties**
   *
   * The philosophy here is that if the developer has
   * custom-defined any properties on the read params
   * then any two or more proxies (readable) that share
   * the equivalent read parameters should be polled in
   * one request.
   */
  public boolean isGroupable()
  {
    return (getReadParameters().getPropertiesArray().length>0);
  }  
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  private IDdfReadable[] readableSource = null;
}
