/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.req;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;

/**
 * This request is used to directly transmit an array of bytes
 * onto the driver's field-bus. 
 * 
 * Please note that this request is used to bypass transaction
 * management and directly transmit an array of bytes onto the
 * driver's field-bus. As a result, no response processing is
 * performed.
 * 
 * Please do not use this request if you need to perform
 * processing on frames received as a result of this
 * transmission. That is not what this is for.
 * 
 * 
 * @author lperkins
 */
public class BDdfRawTransmitRequest
  extends BDdfRequest
{
  /*-
  class BDdfRawTransmitRequest
  {
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.req.BDdfRawTransmitRequest(613337029)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfRawTransmitRequest.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  /**
   * Niagara AX requires an empty constructor. We do not use this.
   * We use the version that takes the byte array as a parameter.
   *
   */
  public BDdfRawTransmitRequest()
  {
  }
  
  /**
   * Constructs a instance to transmit a raw array of
   * bytes.
   * 
   * @param rawBytes a raw array of bytes to directly
   * transmit, without any transaction management.
   */
  public BDdfRawTransmitRequest(byte[] rawBytes)
  {
    this.rawBytes=rawBytes;
  }
  
////////////////////////////////////////////////////////////////
//BIDdfRequest
////////////////////////////////////////////////////////////////

  public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException
  {
    throw new DdfResponseException();
  }

  public byte[] toByteArray()
  {
    return rawBytes;
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  protected byte[] rawBytes;
}
