/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.req;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.discover.IDdfDiscoverer;
import com.tridium.ddf.identify.BDdfIdParams;

/**
 * This is a default, base class that implements BIDdfDiscoverRequest.
 * 
 * The following are related to the automatic discovery mechanism
 * that devDriver provides:
 * 
 * <ul>
 * <li>BIDdfDiscoverRequest
 * <li>BIDdfDiscoverResponse
 * <li>All classes in the packages <i>com.tridium.ddf.discover</i> and <i>com.tridium.ddf.discover.auto</i>
 * </ul>
 * 
 * For more details, please see the Java Doc that is provided with
 * BIDdfDiscoverRequest.
 * 
 * @see BIDdfDiscoverRequest
 * 
 * @author lperkins
 */
public abstract class BDdfDiscoveryRequest
  extends BDdfRequest
  implements BIDdfDiscoverRequest
{
  /*-
  class BDdfDiscoveryRequest
  {
    properties
    {
      discoverParameters : BDdfIdParams
         -- This provides the necessary data that the toByteArray method
         -- Needs in order to construct the byte array.
         -- NOTE: During auto-discovery, the auto discovery job loops
         -- through all possible combinations of discoverParameters. Each
         -- pass through the loop, the next discoverParameters value for
         -- your driver is passed to this property. When you implement
         -- the toByteArray method, you may cast this to your own
         -- discoverParameters class (that is what it will ultimately be).
        default{[new BDdfIdParams()]}
    }
    
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.req.BDdfDiscoveryRequest(3095533647)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "discoverParameters"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>discoverParameters</code> property.
   * This provides the necessary data that the toByteArray
   * method Needs in order to construct the byte array.
   * NOTE: During auto-discovery, the auto discovery job
   * loops through all possible combinations of discoverParameters.
   * Each pass through the loop, the next discoverParameters
   * value for your driver is passed to this property. When you implement the toByteArray method, you may cast this to your own discoverParameters class (that is what it will ultimately be).
   * @see com.tridium.ddf.comm.req.BDdfDiscoveryRequest#getDiscoverParameters
   * @see com.tridium.ddf.comm.req.BDdfDiscoveryRequest#setDiscoverParameters
   */
  public static final Property discoverParameters = newProperty(0, new BDdfIdParams(),null);
  
  /**
   * Get the <code>discoverParameters</code> property.
   * @see com.tridium.ddf.comm.req.BDdfDiscoveryRequest#discoverParameters
   */
  public BDdfIdParams getDiscoverParameters() { return (BDdfIdParams)get(discoverParameters); }
  
  /**
   * Set the <code>discoverParameters</code> property.
   * @see com.tridium.ddf.comm.req.BDdfDiscoveryRequest#discoverParameters
   */
  public void setDiscoverParameters(BDdfIdParams v) { set(discoverParameters,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfDiscoveryRequest.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BIDdfDiscoverRequest
////////////////////////////////////////////////////////////////

  public IDdfDiscoverer getDiscoverer()
  {
    return discoverer;
  }

  public void setDiscoverer(IDdfDiscoverer discoverer)
  {
    this.discoverer=discoverer;
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  IDdfDiscoverer discoverer = null;
}
