/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.multipleTransaction;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.BIDdfTransactionMgr;

/**
 * BIDdfMultipleTransactionMgr classes that would implement BIDdfTransactionMgr
 * and handle multiple outstanding messages on the fieldbus should implement this
 * interface instead. This interface extends BIDdfTransactionMgr but does nothing
 * else, other than document the fact that the transaction manager allows multiple
 * outstanding requests.
 * 
 * Instead of implementing this directly, please consider extending BDdfMultipleTransactionMgr.
 * That could save development time.
 *
 * @author    lperkins
 * @creation  Oct 18, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public interface BIDdfMultipleTransactionMgr
    extends BIDdfTransactionMgr
{
  
////////////////////////////////////////////////////////////////
//Type
////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfMultipleTransactionMgr.class);
}
