/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.defaultComm;

import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.BIDdfUnsolicitedMgr;
import com.tridium.ddf.comm.IDdfDataFrame;

/**
 * This is the base override point for a custom unsolicited
 * message processor. This puts unsolicited data frames
 * on a queue, pulls them off one-by-one (on a dedicated
 * unsolicited mgr therad), and passes them to the abstract
 * processUnsolicitedFrame method for developers to process
 * further.
 * 
 * @author lperkins
 *
 */
public abstract class BDdfUnsolicitedMgr
  extends BComponent
    implements BIDdfUnsolicitedMgr, Runnable
{
  /*-
  class BDdfUnsolicitedMgr
  {
    properties
    {
      unsolicitedMessageCount : long
        -- This is the number of unsolicited messages that have been received by the driver since station startup
        flags {readonly}
        default{[0]}
        slotfacets{[BFacets.make(BFacets.MIN,BInteger.make(0))]}
    }
    
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.defaultComm.BDdfUnsolicitedMgr(28345956)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "unsolicitedMessageCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>unsolicitedMessageCount</code> property.
   * This is the number of unsolicited messages that have
   * been received by the driver since station startup
   * @see com.tridium.ddf.comm.defaultComm.BDdfUnsolicitedMgr#getUnsolicitedMessageCount
   * @see com.tridium.ddf.comm.defaultComm.BDdfUnsolicitedMgr#setUnsolicitedMessageCount
   */
  public static final Property unsolicitedMessageCount = newProperty(Flags.READONLY, 0,BFacets.make(BFacets.MIN,BInteger.make(0)));
  
  /**
   * Get the <code>unsolicitedMessageCount</code> property.
   * @see com.tridium.ddf.comm.defaultComm.BDdfUnsolicitedMgr#unsolicitedMessageCount
   */
  public long getUnsolicitedMessageCount() { return getLong(unsolicitedMessageCount); }
  
  /**
   * Set the <code>unsolicitedMessageCount</code> property.
   * @see com.tridium.ddf.comm.defaultComm.BDdfUnsolicitedMgr#unsolicitedMessageCount
   */
  public void setUnsolicitedMessageCount(long v) { setLong(unsolicitedMessageCount,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfUnsolicitedMgr.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
////////////////////////////////////////////////////////////////
// BComplex
////////////////////////////////////////////////////////////////
  /**
   * Callback from BComponenet
   */
  public boolean isParentLegal(BComponent parent)
  {
    return parent.getType().is(BIDdfCommunicator.TYPE);
  }
  
////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  /**
   * Callback from BComponent. Although this is declared as being
   * final, descendants may override the 'unsolicitedMgrStarted'
   * method.
   */
  public final void started()   
    throws Exception
  {
    unsolicitedMgrStarted();
    super.started();
  }
  
  /**
   * Callback from BComponent. Although this is declared as being
   * final, descendants may override the 'unsolicitedMgrStopped'
   * method.
   */
  public final void stopped()
    throws Exception
  {                
    unsolicitedMgrStopped();
    super.stopped();
  }        

////////////////////////////////////////////////////////////////
// BIDdfUnsolicitedMgr
////////////////////////////////////////////////////////////////
  public void startUnsolicitedMgr()
  {
    if (!(this instanceof BDdfNullUnsolicitedMgr))
    {
      if (stopUnsolicitedMgr)
      {
        stopUnsolicitedMgr = false;
        
        unsolicitedFrameManager = new Queue();
        
        String threadName = "UnsolicitedMgr";
        BIDdfCommunicator comm = getDdfCommunicator();
        
        if (comm!=null && comm instanceof BDdfCommunicator)
        {
          threadName += ':' + ((BDdfCommunicator)comm).getWorkerThreadName();
        }
        
        myThread = new Thread(this, threadName);
        myThread.start();
      }
    }
    
  }
  
  public void stopUnsolicitedMgr()
  {
    if (!(this instanceof BDdfNullUnsolicitedMgr))
    {
      if (!stopUnsolicitedMgr)
      {
        stopUnsolicitedMgr = true;
        myThread.interrupt();
        ddfCommunicator = null;
      }
    }
  }
  
  /**
   * @return (BIDdfCommunicator)getParent()
   */
  public BIDdfCommunicator getDdfCommunicator()
  {
    if (ddfCommunicator == null)
      ddfCommunicator = (BIDdfCommunicator)getParent();
    return ddfCommunicator;
  }
  
  /**
   * Access point called by the DdfCommunicator Comm API to place
   * unsolicited frames on the Unsolicited Manager's queue.
   *
   * @param  ReceivedMessage incoming BasicDriver received message 
   */
   public void enqueueUnsolicitedFrame(IDdfDataFrame unsolicitedFrame)
   {
     if (!(this instanceof BDdfNullUnsolicitedMgr))
       unsolicitedFrameManager.enqueue( unsolicitedFrame);
   }
  
////////////////////////////////////////////////////////////////
// Runnable 
////////////////////////////////////////////////////////////////
  
  public void run()
  {
    IDdfDataFrame unsolicitedFrame;
  
    while(!stopUnsolicitedMgr)
    {
      try
      { 
        // Pulls next message off of Queue, passing -1 causes it to block if there is none
        unsolicitedFrame = (IDdfDataFrame)unsolicitedFrameManager.dequeue(-1);
      }
      catch( InterruptedException ie)
      {
        unsolicitedFrame = null;
        
        if (!stopUnsolicitedMgr)
          try{Thread.sleep(1000);}catch(Exception e){} // Prevents spinning wheels
      }
  
      if ( unsolicitedFrame != null)
      {
        setUnsolicitedMessageCount( getUnsolicitedMessageCount()+1 );
        
        // Calls customized method to process the unsolicited message
        try
        {
          processUnsolicitedFrame(unsolicitedFrame);
        }
        catch (Exception e)
        {
          getDdfCommunicator().getLog().error(myThread.getName(), e);
        }
      }
    }
  }
  
////////////////////////////////////////////////////////////////
// BDdfUnsolicitedMgr
////////////////////////////////////////////////////////////////
  
  /**
   * Descendants should override this method and process to given unsolicited
   * frame. This method is called on the unsolicited manager's own thread.
   */
  public abstract void processUnsolicitedFrame(IDdfDataFrame unsolicitedFrame) throws Exception;

  /**
   * Callback from BDdfCommunicator
   */
  public void resetStatistics()
  {
    setUnsolicitedMessageCount(0);
  }

  /**
   * Override point for descendants during station startup.
   */
  protected void unsolicitedMgrStarted()
  {
  }
  
  /**
   * Override point for descendants during station shutdown.
   */
  protected void unsolicitedMgrStopped()
  {
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  /*
   * A cached ddfCommunicator is necessary to permit client-side communications, which is required
   * for the video driver.
   */
  private BIDdfCommunicator ddfCommunicator;
  
  // This is the queue that holds unsolicited data frames. The unsolicited data
  // frames are pulled off of this Queue in the 'run' method.
  private Queue  unsolicitedFrameManager = null;
  
  // This boolean allows the 'run' method to terminate gracefully
  private boolean stopUnsolicitedMgr = true;

  // This is the thread that runs this object's run method
  private Thread myThread = null;
} 
