/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.defaultComm;

import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BStruct;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.BIDdfTransmitter;
import com.tridium.ddf.comm.req.BIDdfRequest;

/**
 * This is the main override point for a custom
 * transmitter that is not a serial, Tcp/Ip, nor
 * Udp/Ip transmitter. A base serial, Tcp/Ip, and
 * Udp/Ip transmitter is already provided in the
 * devSerialDriver and devIpDriver modules.
 * 
 * @author lperkins
 */
public abstract class BDdfTransmitter
  extends BStruct
  implements BIDdfTransmitter
{
  /*-
   class BDdfTransmitter
   {
     properties
     {
       transmissionAttempts : long
         -- This is the number of field-bus requests that this object has attempted to transmit
         flags{readonly}
         default{[0]}
         slotfacets{[BFacets.make(BFacets.MIN,BInteger.make(0))]}
       transmissionCount : long
         -- This is the number of field-bus messages that have been successfully transmitted
         flags{readonly}
         default{[0]}
         slotfacets{[BFacets.make(BFacets.MIN,BInteger.make(0))]}
       retransmissionCount : long
         -- This is the number of times any one message has been re-sent (total re-transmission count)
         flags{readonly}
         default{[0]}
         slotfacets{[BFacets.make(BFacets.MIN,BInteger.make(0))]}
       maxRetryCount : int
         -- This is the default maximum number of times that any one message will ever be
         -- retransmitted. This property is faceted with MGR_INCLUDE so that it can appear
         -- in the device manager, if the device communicates on its own.
         default{[0]}
         slotfacets{[DdfFacets.combine( MGR_INCLUDE,
                                        BFacets.make(BFacets.MIN,BInteger.make(0)))]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.defaultComm.BDdfTransmitter(634442579)1.0$ @*/
/* Generated Tue Dec 11 13:23:08 EST 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "transmissionAttempts"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>transmissionAttempts</code> property.
   * This is the number of field-bus requests that this
   * object has attempted to transmit
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#getTransmissionAttempts
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#setTransmissionAttempts
   */
  public static final Property transmissionAttempts = newProperty(Flags.READONLY, 0,BFacets.make(BFacets.MIN,BInteger.make(0)));
  
  /**
   * Get the <code>transmissionAttempts</code> property.
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#transmissionAttempts
   */
  public long getTransmissionAttempts() { return getLong(transmissionAttempts); }
  
  /**
   * Set the <code>transmissionAttempts</code> property.
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#transmissionAttempts
   */
  public void setTransmissionAttempts(long v) { setLong(transmissionAttempts,v,null); }

////////////////////////////////////////////////////////////////
// Property "transmissionCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>transmissionCount</code> property.
   * This is the number of field-bus messages that have
   * been successfully transmitted
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#getTransmissionCount
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#setTransmissionCount
   */
  public static final Property transmissionCount = newProperty(Flags.READONLY, 0,BFacets.make(BFacets.MIN,BInteger.make(0)));
  
  /**
   * Get the <code>transmissionCount</code> property.
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#transmissionCount
   */
  public long getTransmissionCount() { return getLong(transmissionCount); }
  
  /**
   * Set the <code>transmissionCount</code> property.
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#transmissionCount
   */
  public void setTransmissionCount(long v) { setLong(transmissionCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "retransmissionCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>retransmissionCount</code> property.
   * This is the number of times any one message has been
   * re-sent (total re-transmission count)
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#getRetransmissionCount
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#setRetransmissionCount
   */
  public static final Property retransmissionCount = newProperty(Flags.READONLY, 0,BFacets.make(BFacets.MIN,BInteger.make(0)));
  
  /**
   * Get the <code>retransmissionCount</code> property.
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#retransmissionCount
   */
  public long getRetransmissionCount() { return getLong(retransmissionCount); }
  
  /**
   * Set the <code>retransmissionCount</code> property.
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#retransmissionCount
   */
  public void setRetransmissionCount(long v) { setLong(retransmissionCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "maxRetryCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>maxRetryCount</code> property.
   * This is the default maximum number of times that any
   * one message will ever be retransmitted. This property
   * is faceted with MGR_INCLUDE so that it can appear in the device manager, if the device communicates on its own.
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#getMaxRetryCount
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#setMaxRetryCount
   */
  public static final Property maxRetryCount = newProperty(0, 0,DdfFacets.combine( MGR_INCLUDE,
                                        BFacets.make(BFacets.MIN,BInteger.make(0))));
  
  /**
   * Get the <code>maxRetryCount</code> property.
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#maxRetryCount
   */
  public int getMaxRetryCount() { return getInt(maxRetryCount); }
  
  /**
   * Set the <code>maxRetryCount</code> property.
   * @see com.tridium.ddf.comm.defaultComm.BDdfTransmitter#maxRetryCount
   */
  public void setMaxRetryCount(int v) { setInt(maxRetryCount,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfTransmitter.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BIDdfTransmitter
////////////////////////////////////////////////////////////////
  /**
   * The BIDdfTransmitter interface requires that this method be implemented. Descendants
   * should overwrite the tryDdfTransmit method. The calling thread should not be blocked
   * waiting for the response. 
   */
  public final void transmitRequest(BIDdfRequest ddfRequest)
  {
    // HACK ALERT: Issue 19456 this try catch is handle the case where this is actually running
    // in the workbench client. If so, do not increment counts to prevent unnecessary 
    // fox traffic and protect against exceptions for read-only permissions.
    BComplex parent = getParent();
    boolean isRunning = false;
    if( parent != null )
    {
      isRunning = parent.isComponent() && ((BComponent)parent).isRunning();
      if(isRunning)
        setTransmissionAttempts(getTransmissionAttempts()+1);
    }
    
    try
    {
      forceTransmit(ddfRequest);
      // HACK ALEART: same as above.
      
      if(isRunning)
        setTransmissionCount(getTransmissionCount()+1);
      // NOTE: Retries are handled by a different mechanansim.
    }
    catch (Exception e)
    {
      if (getDdfCommunicator()==null || getDdfCommunicator().getLog()==null)
      {
        System.out.print("ERROR: ");
        e.printStackTrace();
      }
      else
      {
        // TODO: We need to log the exception
        getDdfCommunicator().getLog().error("TransmitError",e);
      }
    }
    finally
    {
      
    }
  }
  
  /**
   * @return (BIDdfCommunicator)getParent()
   */
  public BIDdfCommunicator getDdfCommunicator()
  {
    if (communicator == null)
      communicator = (BIDdfCommunicator)getParent();
    return communicator;
  }
  
  public void startTransmitter()
  {
  }

  public void stopTransmitter()
  {
    communicator = null;    
  }
  
////////////////////////////////////////////////////////////////
// BDdfTransmitter
////////////////////////////////////////////////////////////////
  
  /**
   * This method is called by the parent communicator's "resetStatistics"
   * action.
   */
  public void resetStatistics()
  {
    setTransmissionAttempts(0);
    
    setTransmissionCount(0);
    
    setRetransmissionCount(0);
  }
  
  /**
   * Determines the maximum permissible number of retransmissions for the given request.
   * 
   * @param ddfRequest a request to determine the retry count for.
   * 
   * @return the value of the 'Max Retry Count' property if ddfRequest.getRemainingRetryCount()
   * is not customized (in other words, the value is BIDdfRequest.USE_DEFAULT_RETRY_COUNT) or
   * ddfRequest.getRemainingRetryCount() otherwise. 
   */
  public int getMaxRetryCount(BIDdfRequest ddfRequest)
  {
    if (ddfRequest.getRemainingRetryCount()==BIDdfRequest.USE_DEFAULT_RETRY_COUNT)
      return getMaxRetryCount();
    else
      return ddfRequest.getRemainingRetryCount();
  }
  
  /**
   * Maintains a cached reference to the communicator. This not only optimizes
   * cpu utilization but also allows client-side communications to occur (to
   * facilitate video streaming in videDriver and devVideoDriver)
   */
  BIDdfCommunicator communicator;
}
