/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.defaultComm;

import javax.baja.log.Log;
import javax.baja.sys.BComplex;
import javax.baja.sys.BStruct;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.BIDdfCommunicating;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.BIDdfReceiver;
import com.tridium.ddf.comm.BIDdfTransactionMgr;
import com.tridium.ddf.comm.BIDdfTransmitter;
import com.tridium.ddf.comm.BIDdfUnsolicitedMgr;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.poll.BIDdfPollScheduler;

/**
 * BDdfNullCommunicator is a place holder for components, such as DdfDevices on behalf of
 * which Niagara AX must communicate through another component (such as an DdfNetwork).
 *
 * This passes all communication requests up to the nearest Niagara AX Nav ancestor that
 * implements BIDdfCommunicating.
 * 
 * Unlike the BDDfNullReceiver and BDdfNullTransactionMgr, this class can be
 * usefull as delegating communicator to delegate communication requests up the
 * Niagara AX Nav ancestry.
 * 
 * 
 * Note that this class extends BStruct to make it light-weight as compared to BComponent.
 *
 * @author    lperkins
 * @creation  Oct 16, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BDdfNullCommunicator
  extends BStruct
  implements BIDdfCommunicator
{
  /*-
   class BDdfNullCommunicator
   {
   
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.defaultComm.BDdfNullCommunicator(4061299942)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfNullCommunicator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BIDdfCommunicator
////////////////////////////////////////////////////////////////
  
  /**
   * Calls getDdfCommunicatingComponent().getDdfCommunicator().communicate(ddfRequest);
   * 
   * @return getDdfCommunicatingComponent().getDdfCommunicator().communicate(ddfRequest);
   */
  public void communicate(BIDdfRequest ddfRequest)
  {
    getDdfCommunicatingComponent().getDdfCommunicator().communicate(ddfRequest);
  }
  
  /**
   * Returns getDdfCommunicatingComponent().getDdfCommunicator().getDdfReceiver();
   * 
   * @return getDdfCommunicatingComponent().getDdfCommunicator().getDdfReceiver();
   */
  public BIDdfReceiver getDdfReceiver()
  {
    return getDdfCommunicatingComponent().getDdfCommunicator().getDdfReceiver();
  }
  
  /**
   * Returns getDdfCommunicatingComponent().getDdfCommunicator().getDdfTransactionMgr();
   * 
   * @return getDdfCommunicatingComponent().getDdfCommunicator().getDdfTransactionMgr();
   */
  public BIDdfTransactionMgr getDdfTransactionMgr()
  {
    return getDdfCommunicatingComponent().getDdfCommunicator().getDdfTransactionMgr();
  }
  
  /**
   * Returns getDdfCommunicatingComponent().getDdfCommunicator().getDdfTransmitter();
   * 
   * @return getDdfCommunicatingComponent().getDdfCommunicator().getDdfTransmitter();
   */
  public BIDdfTransmitter getDdfTransmitter()
  {
    return getDdfCommunicatingComponent().getDdfCommunicator().getDdfTransmitter();
  }
  
  /**
   * Returns getDdfCommunicatingComponent().getDdfCommunicator().getLog();
   * 
   * @return getDdfCommunicatingComponent().getDdfCommunicator().getLog();
   */
  public Log getLog()
  {
    return getDdfCommunicatingComponent().getDdfCommunicator().getLog();
  }
  
  /**
   * Returns getDdfCommunicatingComponent().getDdfCommunicator().getDdfPollScheduler();
   * 
   * @return getDdfCommunicatingComponent().getDdfCommunicator().getDdfPollScheduler();
   */
  public BIDdfPollScheduler getDdfPollScheduler()
    throws IllegalAccessException
  {
    return getDdfCommunicatingComponent().getDdfCommunicator().getDdfPollScheduler();
  }
  
  /**
   * Returns getDdfCommunicatingComponent().getDdfCommunicator().getDdfUnsolicitedMgr();
   * 
   * @return getDdfCommunicatingComponent().getDdfCommunicator().getDdfUnsolicitedMgr();
   */
  public BIDdfUnsolicitedMgr getDdfUnsolicitedMgr()
  {
    return getDdfCommunicatingComponent().getDdfCommunicator().getDdfUnsolicitedMgr();
  }

  /**
   * Calls getDdfCommunicatingComponent().getDdfCommunicator().stopCommunicating();
   */
  public void stopCommunicating()
  {
    getDdfCommunicatingComponent().getDdfCommunicator().stopCommunicating();
  }
  
  /**
   * Calls getDdfCommunicatingComponent().getDdfCommunicator().startCommunicating();
   */
  public void startCommunicating()
  {
    getDdfCommunicatingComponent().getDdfCommunicator().startCommunicating();
  }
  
////////////////////////////////////////////////////////////////
// BDdfNullCommunicator
////////////////////////////////////////////////////////////////
  
  /**
   * Looks up the Niagara AX Navigation ancestry tree for the nearest ancestor that
   * implements BIDdfCommunicating (This is typically an instance of BDdfCommDevice
   * or BDdfCommNetwork) -- this is the component that owns the <i>real</i> communicator
   * component.
   */
  public BIDdfCommunicating getDdfCommunicatingComponent()
  {
    if (commParent == null)
    {
      // Finds the communicating parent
      BComplex parent = getParent();
    
      while (parent!=null && (!(parent instanceof BIDdfCommunicating)))
      {
        parent = parent.getParent();
      }
      
      // Cache the commParent. This is important for client-side
      // video stream communication. The client-side proxy goes
      // out of scope so getParent() will eventually return null.
      // For this reason, we better cache it now.
      commParent = (BIDdfCommunicating)parent;
    }
    
    // Returns the cached communicating parent reference
    return commParent;
  }
  
  /**
   * This variable is being added after the release of this module
   * so access is therefore restricted in order to preserve API
   * stability. 
   */
  BIDdfCommunicating commParent;
  
}
