/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.req.BIDdfRequest;

/**
 * The BIDdfTransactionMgr matches up received data frames to transmitted
 * requests or to the BIDdfUnsolicitedMgr.
 * 
 * 
 * Instead of implementing this directly, there are a wealth of implementations that can be extends.
 * These are in the packages:
 * <OL>
 *   <LI>com.tridium.ddf.comm.defaultComm
 *   <LI>com.tridium.ddf.comm.multipleTransaction
 *   <LI>com.tridium.ddf.comm.singleTransaction
 * </OL>
 * In additon, there reasonable serial versions of these in the devSerialDriver module.
 * 
 * There are reasonable Tcp/Ip versions of these in the devTcpDriver module.
 * @author lperkins
 */
public interface BIDdfTransactionMgr
    extends BInterface, IDdfFacetConst
{
  /**
   * This method asks the transaction manager to arrange for a resposne
   * to be received for the given request.
   * 
   * @param req the given request.
   * 
   */ 
  public void processTransaction(BIDdfRequest req);
  
  /**
   * @return the communicator component that owns this transaction mgr.
   */
  public BIDdfCommunicator getDdfCommunicator();
  
  /**
   * This method is called to start any threads that process transactions.
   */
  public void startTransactionMgr();
  
  /**
   * This method is called to stop any threads that process transactions.
   */
  public void stopTransactionMgr();
  
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfTransactionMgr.class);
}
