/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.IDdfFacetConst;

/**
 * Components such as subclasses of BDdfDevice or BDdfNetwork implement this if they require
 * their own personal BDdfCommunicator for communication to their corresponding foreign
 * hardware.
 * 
 * Instead of implementing this directly, developers should consider extending BDdfCommNetwork or
 * BDdfCommDevice (or a subclass of one of them from the devSerialDriver or devIpDriver
 * module)
 * 
 * @author    lperkins
 * @creation  Oct 9, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public interface BIDdfCommunicating
  extends BInterface, IDdfFacetConst
{
  /**
   * This method is called to get the object that performs
   * the driver field-bus communications.
   */
  public BIDdfCommunicator getDdfCommunicator();
  
  /**
   * Networks and devices inherit this method from BDeviceNetwork
   * and BDevice. The Ddf-Point-Device-ext returns getDevice().isDisabled().
   */
  public boolean isDisabled();
  
  /**
   * Networks and devices inherit this method from BDeviceNetwork
   * and BDevice. The Ddf-Point-Device-ext returns getDevice().isFault().
   */
  public boolean isFault();
  
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfCommunicating.class);
  
}
