/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.clock;

import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ExpiredTicketException;
import javax.baja.sys.Clock.Ticket;

/**
 * The BDdfScheduler uses this class to help it schedule actions
 * on behalf of this framework.
 * 
 * @author lperkins
 */

public class DdfSchedulerTicket
  implements Ticket
{
  
  /**
   * Constructs an instance of DdfSchedulerTicket.
   * 
   * @param host component on which to invoke the given action
   * 
   * @param action the action to invoke on the given host component
   * 
   * @param arg the argument to pass to the given action when invoked on the
   *        host component.
   *        
   * @param serviceTicks the tick count when this ticket should be processed.
   */
  public DdfSchedulerTicket(BComponent host, Action action, BValue arg, long serviceTicks)
  {
    this.host=host;
    this.action=action;
    this.arg=arg;
    this.serviceTicks = serviceTicks;
  }
  
////////////////////////////////////////////////////////////////
// Ticket 
////////////////////////////////////////////////////////////////
  
  /**
   * Sets an internal 'expired' flag to true and removes this
   * ticket from the BDdfScheduler.INSTANCE's queue
   */
  public void cancel()
  {
    expired=true;
    BDdfScheduler.INSTANCE.cancelTicket(this);
  }

  public Action getAction()
  {
    if (expired)
      throw new ExpiredTicketException();
    else
      return action;
  }

  public BValue getActionArgument()
  {
    if (expired)
      throw new ExpiredTicketException();
    else
      return arg;
  }

  public BComponent getComponent()
  {
    if (expired)
      throw new ExpiredTicketException();
    else
      return host;
  }

  public boolean isExpired()
  {
    return expired;
  }
  
  protected void invokeAction()
  {
    if (!expired)
    {
      expired=true;
      host.invoke(action,arg,Context.commit);
    }
  }
  
  /**
   * The component on which to invoke an action.
   */
  final BComponent host;
  
  /**
   * The action to invoke on the host component.
   */
  final Action action;
  
  /**
   * The argument to pass to the action that is to be invoked on the host
   * component.
   */
  final BValue arg;
  
  /**
   * Indicates whether this ticket is expired.
   */
  boolean expired;
  
  /**
   * The BDdfScheduler will set this to indicate when the particular action
   * should be invoked on the host component.
   */
  final long serviceTicks;
}
