/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf;

import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

/**
 * These constants help driver developers when declaring
 * properties in slotomatic statements to customize the
 * developer device manager and developer point manager.
 * 
 * Most, if not all, classes in this framework implement
 * this interface and therefore inherit these attributes
 * 
 * @author lperkins
 *
 */
public interface IDdfFacetConst
{
  
////////////////////////////////////////////////////////////////
// Attributes - Special Ddf Contexts
////////////////////////////////////////////////////////////////
  
  /**
   * This context is passed to the 'isExisting' method of the pointId,
   * readParameters, and/or writeParameters structures on a proxy ext
   * to determine if it is an existing database representation of the
   * discovery object.
   * 
   * This constant does not have anything to do with facets but was thrown
   * in with this class as a convenience since just about all classes in
   * the developer driver framework already implement this interface to inherit
   * its static fields. 
   */
  public static final Context CONTEXT_POINT_MANAGER = new BasicContext();
  
  /**
   * This context is passed to the 'isExisting' method of the deviceId,
   * and/or pingParameters structures on a proxy ext
   * to determine if it is an existing database representation of the
   * discovery object.
   * 
   * This constant does not have anything to do with facets but was thrown
   * in with this class as a convenience since just about all classes in
   * the developer driver framework already implement this interface to inherit
   * its static fields. 
   */
  public static final Context CONTEXT_DEVICE_MANAGER = new BasicContext();
  
  /**
   * This context is returned from the IDdfDiscoverer.getDiscoverContext()
   * method (for Ddf Device Mgr discovery). This is part of the BDdfAutoDiscoveryJob.
   * 
   * It is part of the mechanism that provides a developer's device discovery request
   * with access back into the discovery job. 
   */
  public static final Context CONTEXT_DISCOVERING_DEVICES = new BasicContext();
  
  /**
   * This context is returned from the IDdfDiscoverer.getDiscoverContext()
   * method (for Ddf Point Mgr discovery). This is part of the BDdfAutoDiscoveryJob.
   * 
   * It is part of the mechanism that provides a developer's device discovery request
   * with access back into the discovery job. 
   */
  public static final Context CONTEXT_DISCOVERING_POINTS = new BasicContext();
  
  
////////////////////////////////////////////////////////////////
// Attributes - Special Ddf Facets and Facet Keys
////////////////////////////////////////////////////////////////
  
  static final String KEY_MGR_NOT_IN_DIALOG = "MgrNotInDialog";
  /**
   * The MGR_NOT_IN_DIALOG facet causes a point that is in the developer device or point manager to not
   * be present in the edit dialog that appears when a database row is double clicked or when a
   * new database component is added to the station.
   * 
   * The developer manager only checks properties that are flavors of BSimple for this facet. Therefore,
   * adding this facet to properties that are not BSimples will have no effect.
   * 
   * Please note that the property must also include the MGR_INCLUDE facet for the developer manager to even
   * consider this facet.
   */
  public static final BFacets MGR_NOT_IN_DIALOG = BFacets.make(KEY_MGR_NOT_IN_DIALOG, BBoolean.TRUE);
  
  static final String KEY_MGR_OPTIONAL_IN_TABLE = "MgrOptionalInTable";
  
  /**
   * The MGR_OPTIONAL_IN_TABLE facet causes the developer device or point manager to not include a property
   * in the main database table, however, the property will appear in a list of optional columns that
   * the user can choose to add to the database table if he or she wishes. 
   * 
   * The developer manager only checks properties that are flavors of BSimple for this facet. Therefore,
   * adding this facet to properties that are not BSimples will have no effect.
   * 
   * Please note that the property must also include the MGR_INCLUDE facet for the developer manager to even
   * consider this facet.
   */
  public static final BFacets MGR_OPTIONAL_IN_TABLE = BFacets.make(KEY_MGR_OPTIONAL_IN_TABLE, BBoolean.TRUE);
  
  static final String KEY_MGR_INCLUDE = "MgrInclude";
  
  /**
   * The MGR_INCLUDE facet causes the developer device or point manager to:
   * 1.) If the property is a flavor of BSimple then the property will appear in the manager's
   * database table and possibly the manager's edit dialog. The exact behavior will be governed
   * by the presence of the MGR_NOT_IN_DIALOG, MGR_OPTIONAL_IN_TABLE, AND MGR_READONLY facets.
   * 
   * 2.) If the property is a flavor of BComplex then the manager will recurse below the complex
   * in search of BSimples with the MGR_INCLUDE facet (as described in line item 1). 
   */
  public static final BFacets MGR_INCLUDE = BFacets.make(KEY_MGR_INCLUDE, BBoolean.TRUE);
  
  static final String KEY_MGR_READONLY = "MgrReadonly";
  
  /**
   * The MGR_READONLY facet causes the developer device or point manager to render the property as
   * read-only (grayed-out) in the manager's edit-dialog.
   * 
   * Please note that if a property is flagged as MGR_NOT_IN_DIALOG then the developer manager will
   * not include the property in the edit dialog. Therefore, combining MGR_NOT_IN_DIALOG with
   * MGR_READONLY causes the MGR_READONLY to have no effect.
   * 
   * The developer manager only checks properties that are flavors of BSimple for this facet. Therefore,
   * adding this facet to properties that are not BSimples will have no effect.
   * 
   * Please note that the property must also include the MGR_INCLUDE facet for the developer manager to even
   * consider this facet.
   */
  public static final BFacets MGR_READONLY = BFacets.make(KEY_MGR_READONLY, BBoolean.TRUE);
  
  static final String KEY_MGR_NAME = "MgrName";
}
