/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf;

import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/**
 * The attributes and methods of this class help clean up the source code
 * in other locations that is required to localize text.
 * 
 * @author lperkins
 */
public class DdfLexicon
{
  public static final Lexicon LEX = Lexicon.make(DdfLexicon.class);
  
  // This is a message that the driver developer should see rather early in his or her driver development.
  // It indicates that a particular class that extends BDdfIdParams also needs to properly implment the BIDdfPingParams
  // Interface. He or she will need to resolve this.  The data in parameter {0} identifies the Type of the offending subclass of BDdfPingParams.
  // ddfPingIdNeedsImplemented = The following type needs to properly implement BIDdfPingParams: {0}.
  public static final String DEV_PING_ID_NEEDS_IMPLEMENTED = "ddfPingIdNeedsImplemented";
  
  public static final String ddfPingIdNeedsImplemented(Type t)
  {
    return LEX.getText(DEV_PING_ID_NEEDS_IMPLEMENTED,
           new Object[]{t.getDisplayName(null)});
  }
  
  
  
  // This is a message that the driver developer should see rather early in his or her driver development.
  // It indicates that a particular class that extends BDdfIdParams also needs to properly implment the BIDdfDiscoverParams
  // Interface. He or she will need to resolve this.  The data in parameter {0} identifies the Type of the offending subclass of BDdfIdParams.
  // ddfDiscoverParamsNeedsImplemented = The following type needs to properly implement BIDdfDiscoverParams: {0}.
  public static final String DDF_DISCOVER_PARAMS_NEEDS_IMPLEMENTED = "ddfDiscoverParamsNeedsImplemented";
  
  public static final String ddfDiscoverParamsNeedsImplemented(Type t)
  {
    return LEX.getText(DDF_DISCOVER_PARAMS_NEEDS_IMPLEMENTED,
           new Object[]{t.getDisplayName(null)});
  }
  
  
  
  public static final String DDF_COMMUNICATE_SYNC_ERROR = "communicateSyncError";
  
  public static final String ddfCommunicateSyncError = LEX.getText(DDF_COMMUNICATE_SYNC_ERROR);
  
  
  
  // This message is printed in the standard output window in the event that a user navigates
  // Back to a Ddf device manage or Ddf point manager after the most recently invoked job
  // Has been flushed from the job service. The ddf attempts to restore the most recently
  // Invoked job, however, if enough time passes by then the Job might no longer be available
  public static final String DDF_MGR_JOB_EXPIRED = "ddfMgrJobExpired";
  
  public static final String ddfMgrJobExpired = LEX.getText(DDF_MGR_JOB_EXPIRED);
    
}
