/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf;

import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.Property;

/**
 * This class provides utility methods to check if a particular property
 * is defined with special slotfacets that allow this framework to automatically
 * provide the user interface for the driver's device manager and point manager. 
 * 
 * @author lperkins
 *
 */
public class DdfFacets
  implements IDdfFacetConst
{
  
////////////////////////////////////////////////////////////////////////////
// Util - Interrogation for facets with special meaning to the DDf Ui Mgr
////////////////////////////////////////////////////////////////////////////
  
  /**
   * Checks if the given property of the given parent contains the
   * MGR_OPTIONAL_IN_TABLE facet.
   * 
   * @param parent the given parent
   * 
   * @param prop the given property that is on the given parent
   * 
   * @return true if the given property on the given parent contains
   * the MGR_OPTIONAL_IN_TABLE facet.
   */
  public static boolean isMgrOptionalInTable(BComplex parent, Property prop)
  {
    return checkKey(parent,prop,KEY_MGR_OPTIONAL_IN_TABLE);
  }
  
  /**
   * Checks if the given property of the given parent contains the
   * MGR_INCLUDE facet.
   * 
   * @param parent the given parent
   * 
   * @param prop the given property that is on the given parent
   * 
   * @return true if the given property on the given parent contains
   * the MGR_INCLUDE facet.
   */
  public static boolean isMgrInclude(BComplex parent, Property prop)
  {
    return checkKey(parent,prop,KEY_MGR_INCLUDE);
  }
  
  /**
   * Checks if the given property of the given parent contains the
   * MGR_NOT_IN_DIALOG facet.
   * 
   * @param parent the given parent
   * 
   * @param prop the given property that is on the given parent
   * 
   * @return true if the given property on the given parent contains
   * the MGR_NOT_IN_DIALOG facet.
   */
  public static boolean isMgrNotInDialog(BComplex parent, Property prop)
  {
    return checkKey(parent,prop,KEY_MGR_NOT_IN_DIALOG);
  }
  
  /**
   * Checks if the given property of the given parent contains the
   * MGR_READONLY facet.
   * 
   * @param parent the given parent
   * 
   * @param prop the given property that is on the given parent
   * 
   * @return true if the given property on the given parent contains
   * the MGR_READONLY facet.
   */
  public static boolean isMgrReadOnly(BComplex parent, Property prop)
  {
    return checkKey(parent,prop,KEY_MGR_READONLY);
  }
  
////////////////////////////////////////////////////////////////////////////////////
//Util - Allows for cleaner slotomatic heading in the ddf and any descendant drivers
////////////////////////////////////////////////////////////////////////////////////
  
  /**
   * Slotomatic statements can call this as a convenience to combine
   * two sets of facets into one.
   */
  public static BFacets combine(BFacets f1, BFacets f2)
  {
    return BFacets.make(f1,f2);
  }
  
  /**
   * Slotomatic statements can call this as a convenience to combine
   * three sets of facets into one.
   */
  public static BFacets combine(BFacets f1, BFacets f2, BFacets f3)
  {
    return
      combine(
          combine(f1,f2),
          f3);
  }
  
  /**
   * Slotomatic statements can call this as a convenience to combine
   * four sets of facets into one.
   */
  public static BFacets combine(BFacets f1, BFacets f2, BFacets f3, BFacets f4)
  {
    return
      combine(
          combine(f1,f2,f3),
          f4);
  }
  
  /**
   * Slotomatic statements can call this as a convenience to combine
   * five sets of facets into one.
   */
  public static BFacets combine(BFacets f1, BFacets f2, BFacets f3, BFacets f4, BFacets f5)
  {
    return
      combine(
          combine(f1,f2,f3,f4),
          f5);
  }  
  
  /**
   * Slotomatic statements can call this as a convenience to combine
   * six sets of facets into one.
   */
  public static BFacets combine(BFacets f1, BFacets f2, BFacets f3, BFacets f4, BFacets f5, BFacets f6)
  {
    return
      combine(
          combine(f1,f2,f3,f4,f5),
          f6);
  }  
  
  /**
   * Slotomatic statements can call this as a convenience to combine
   * seven sets of facets into one.
   */
  public static BFacets combine(BFacets f1, BFacets f2, BFacets f3, BFacets f4, BFacets f5, BFacets f6, BFacets f7)
  {
    return
      combine(
          combine(f1,f2,f3,f4,f5,f6),
          f7);
  }  
  
  /**
   * Slotomatic statements can call this as a convenience to combine
   * eight sets of facets into one.
   */
  public static BFacets combine(BFacets f1, BFacets f2, BFacets f3, BFacets f4,
                                BFacets f5, BFacets f6, BFacets f7, BFacets f8)
  {
    return
      combine(
          combine(f1,f2,f3,f4,f5,f6,f7),
          f8);
  }
  
  /**
   * Slotomatic statements can call this as a convenience to combine
   * nine sets of facets into one.
   */
  public static BFacets combine(BFacets f1, BFacets f2, BFacets f3, BFacets f4,
                                BFacets f5, BFacets f6, BFacets f7, BFacets f8,
                                BFacets f9)
  {
    return
      combine(
        combine(f1,f2,f3,f4,f5,f6,f7,f8),
        f9);
  }
  
  /**
   * Slotomatic statements can call this as a convenience to combine
   * ten sets of facets into one.
   */
  public static BFacets combine(BFacets f1, BFacets f2, BFacets f3, BFacets f4,
                                  BFacets f5, BFacets f6, BFacets f7, BFacets f8,
                                  BFacets f9, BFacets f10)
  {
    return
    combine(
      combine(f1,f2,f3,f4,f5,f6,f7,f8,f9),
        f10);
    
  }
  
////////////////////////////////////////////////////////////////////////////////////
// Util - Scan a property's slot facets for a boolean facet value
////////////////////////////////////////////////////////////////////////////////////
  
  private static boolean checkKey(BComplex parent, Property prop, String key)
  {
    return checkKey(key, parent.getSlotFacets(prop));
  }
  
  private static boolean checkKey(String key, BFacets facets)
  {
    return facets.getb(key,false);
  }
}
