/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf;

import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BWorker;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

/**
 * This is a default implementation of BWorker that uses
 * and infinite length queue, bound only by available memory
 * in the station, to process items.
 */
public final class BDdfWorker
  extends BWorker
  implements IDdfFacetConst
{
  /*-
   class BDdfWorker
   {
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.BDdfWorker(330631419)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfWorker.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
////////////////////////////////////////////////////////////////
// BWorker
////////////////////////////////////////////////////////////////
  /**
   * Starts the worker thread provided that the closest Nav ancestor network
   * or device is neither in fatalFault nor disabled.
   */
  protected void startWorker()
  {
    if (isStartable())
    {
      super.startWorker();
    }
  }

  /**
   * Provides the Worker (which is essentially a Thread wrapper) for
   * this object.
   * 
   *  @return a direct reference to the 'communicationWorker'
   */
  public Worker getWorker()
  {
    return  communicationWorker;
  }  
  
////////////////////////////////////////////////////////////////
// BDdfWorker
////////////////////////////////////////////////////////////////
  /**
   * Places the given Runnable on the worker's queue. The worker's
   * thread will pull the Runnable off the the worker's queue in the
   * order that it was placed on the queue and call the 'run' method
   * on the worker's thread.
   * 
   * @param r a Runnable to place on the worker's queue to be processed
   * as soon as possible on the worker's thread.
   */
  public void processInBackground(Runnable r)
  {
    if (!isRunning() || infiniteQueue == null)
      throw new NotRunningException();
    
    //NCCB-3397. Check for the Worker running state.
    //If the worker is not in running state, check for if BDdfWorker is startable and then start worker
    if(!getWorker().isRunning() )
    {
      if(!isStartable()) throw new BajaRuntimeException("Worker is not startable.");
      super.startWorker();
    }
    infiniteQueue.enqueue(r);
  }
  
  /**
   * Had to make this default access since this method was added after
   * the release devDriver. This maintains API stability.
   * @return
   */
  boolean isStartable()
  {
    // Looks up the ancestry for the first device or network and
    // Keys off of its status
    BComponent parent = (BComponent)getParent();
    while (parent!=null)
    {
      if (parent instanceof BDevice)
        return !(((BDevice)parent).isDisabled() || ((BDevice)parent).isFault());
      else if (parent instanceof BDeviceNetwork)
        return !(((BDeviceNetwork)parent).isDisabled() || ((BDeviceNetwork)parent).isFault()) ;
      else
        parent = (BComponent)parent.getParent();
    }
    // If the logic makes it this far then this transaction mgr is not
    // a nav node that is anywhere under a device or a network. This is
    // not a valid use scenario.
    return true;
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  // This is the communicationWorker's queue
  Queue infiniteQueue = new Queue();
  
  // This essentially wraps a Thread and the infiniteQueue
  Worker communicationWorker = new Worker(infiniteQueue);

}
