/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf;

import javax.baja.agent.AgentList;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.BIDdfCommunicating;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.discover.BDdfDiscoveryPreferences;
import com.tridium.ddf.discover.BIDdfDiscoveryHost;
import com.tridium.ddf.discover.auto.BDdfAutoDiscoveryJob;
import com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences;

/**
 * The Ddf Point Device Ext makes use of the ddf driver
 * framework to automatically provide a fully-functional
 * default behavior.
 */
public abstract class BDdfPointDeviceExt
  extends BPointDeviceExt
  implements BIDdfCommunicating, BIDdfDiscoveryHost, IDdfFacetConst
{

  /*-
   class BDdfPointDeviceExt
   {
    properties
    {
      discoveryPreferences : BDdfDiscoveryPreferences
        -- This saves the last set of discovery preferences that the user provided
        -- on the point manager.
        -- Descendants should re-define this property and provide a custom default
        -- Value whose class extends BDdfAutoDiscoveryPreferences.
        default{[ new BDdfAutoDiscoveryPreferences()]}
    }
    actions
    {
      submitDiscoveryJob( preferences : BDdfAutoDiscoveryPreferences ) : BOrd
        -- Submits a ddf auto discovery job and returns a BOrd to the job that is kicked off
        -- And managed by the Niagara Ax Job Service.
        flags{hidden}
        default{[new BDdfAutoDiscoveryPreferences()]}
    }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.BDdfPointDeviceExt(2515103213)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "discoveryPreferences"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>discoveryPreferences</code> property.
   * This saves the last set of discovery preferences that
   * the user provided on the point manager. Descendants
   * should re-define this property and provide a custom
   * default Value whose class extends BDdfAutoDiscoveryPreferences.
   * @see com.tridium.ddf.BDdfPointDeviceExt#getDiscoveryPreferences
   * @see com.tridium.ddf.BDdfPointDeviceExt#setDiscoveryPreferences
   */
  public static final Property discoveryPreferences = newProperty(0, new BDdfAutoDiscoveryPreferences(),null);
  
  /**
   * Get the <code>discoveryPreferences</code> property.
   * @see com.tridium.ddf.BDdfPointDeviceExt#discoveryPreferences
   */
  public BDdfDiscoveryPreferences getDiscoveryPreferences() { return (BDdfDiscoveryPreferences)get(discoveryPreferences); }
  
  /**
   * Set the <code>discoveryPreferences</code> property.
   * @see com.tridium.ddf.BDdfPointDeviceExt#discoveryPreferences
   */
  public void setDiscoveryPreferences(BDdfDiscoveryPreferences v) { set(discoveryPreferences,v,null); }

////////////////////////////////////////////////////////////////
// Action "submitDiscoveryJob"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>submitDiscoveryJob</code> action.
   * Submits a ddf auto discovery job and returns a BOrd
   * to the job that is kicked off And managed by the Niagara
   * Ax Job Service.
   * @see com.tridium.ddf.BDdfPointDeviceExt#submitDiscoveryJob()
   */
  public static final Action submitDiscoveryJob = newAction(Flags.HIDDEN,new BDdfAutoDiscoveryPreferences(),null);
  
  /**
   * Invoke the <code>submitDiscoveryJob</code> action.
   * @see com.tridium.ddf.BDdfPointDeviceExt#submitDiscoveryJob
   */
  public BOrd submitDiscoveryJob(BDdfAutoDiscoveryPreferences preferences) { return (BOrd)invoke(submitDiscoveryJob,preferences,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfPointDeviceExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  /**
   * Uses the value of property deviceDiscoveryParams as the default parameter
   * for the submitDeviceDiscoveryJob action.
   */
  public BValue getActionParameterDefault(Action action)
  {
    if (action.equals(submitDiscoveryJob))
      return getDiscoveryPreferences();
    else
      return super.getActionParameterDefault(action);
  }
  
  /**
   * Gets the agent list.  Adds BDdfPointManager as "Your Driver Point Manager" if one
   * not already registered.
   *
   * @see DdfAgentInfo.getAgentsHelp
   */
  public AgentList getAgents(Context cx)
  {
    return DdfAgentInfo.getAgentsHelp(
        super.getAgents(cx),
        getType().getTypeInfo().getModuleName(),
        "devDriver:DdfPointManager",
        "PointManager",
        "Point Manager");

  }
  
  
////////////////////////////////////////////////////////////////
// BIDdfCommunicating
////////////////////////////////////////////////////////////////
  
  /**
   * This returns the communicator for this object's Nav ancestor
   * device.
   * 
   * @return ((BDdfDevice)getDevice()).getDdfCommunicator()
   */
  public BIDdfCommunicator getDdfCommunicator()
  {
    return ((BDdfDevice)getDevice()).getDdfCommunicator();
  }
  
  /**
   * @return getDevice().isDisabled()
   */
  public boolean isDisabled()
  {
    return getDevice().isDisabled();
  }

  /**
   * @return getDevice().isFault()
   */
  public boolean isFault()
  {
    return getDevice().isFault();
  }
  
////////////////////////////////////////////////////////////////
// BDdfPointDeviceExt
////////////////////////////////////////////////////////////////
  
  /**
   * Implements the 'submitDiscoveryJob' action on the station-side.
   * 
   * This submits a BDdfAutoDiscoveryJob for the given BDdfAutoDiscoveryPreferences
   * to the Job Service.
   * 
   * @param The BDdfAutoDiscoveryPreferences that were passed to this action. This
   * is a copy of the user's selection from when he or she clicked the 'Discover'
   * button from the point manager.
   * 
   * @return a BOrd to the BDdfAutoDiscoveryJob that is running in the
   * background and is connected to the Job Service.
   */
  public BOrd doSubmitDiscoveryJob(BDdfAutoDiscoveryPreferences preferences)
  {
    setDiscoveryPreferences((BDdfAutoDiscoveryPreferences)preferences.newCopy()); // Saves the most recent device discovery parameters
    // Instantiates an instance of BDdfAutoDiscoveryJob passing it a reference to this network
    BDdfAutoDiscoveryJob ddfDeviceDiscoveryJob = new BDdfAutoDiscoveryJob(this);
    // Passes the discovery parameters to the job
    ddfDeviceDiscoveryJob.setDiscoveryPreferences((BDdfAutoDiscoveryPreferences)preferences.newCopy());
    // Submits the job and returns the Ord to the job as a child under the job service
    return ddfDeviceDiscoveryJob.submit(DEV_DEVICE_EXT_DISCOVER_ACTION);
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
 
  /**
   * The 'ddoSubmitDiscoveryJob' method uses this context when it submits the BDdfAutoDiscoveryJob.
   */
  public static final Context DEV_DEVICE_EXT_DISCOVER_ACTION = new BasicContext();
}
