/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf;

import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

import com.tridium.ddf.comm.BIDdfCommunicating;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.defaultComm.BDdfCommunicator;
import com.tridium.ddf.discover.BDdfDiscoveryPreferences;
import com.tridium.ddf.discover.BIDdfDiscoveryHost;
import com.tridium.ddf.discover.auto.BDdfAutoDiscoveryJob;
import com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences;

/**
 * BDdfCommNetwork is the ancestor for Niagara AX Ddf Networks that will
 * have their own real ddf communicator.
 *
 * @author    lperkins
 * @creation  Oct 16, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public abstract class BDdfCommNetwork
  extends BDdfNetwork
  implements BIDdfCommunicating, BIDdfDiscoveryHost
{
  /*-
   class BDdfCommNetwork
   {
    properties
    {
      communicator : BValue
        -- This component communicates on behalf of this device
        -- The BValues for this property must implement BIDdfCommunicator
        default{[ new BDdfCommunicator() ]}
      discoveryPreferences : BDdfDiscoveryPreferences
        -- This saves the last set of discovery preferences that the user provided.
        -- Descendants should re-define this property and provide a custom default
        -- Value whose class extends BDdfAutoDiscoveryPreferences.
        default{[ new BDdfAutoDiscoveryPreferences()]}
    }
    actions
    {
      submitDiscoveryJob( preferences : BDdfAutoDiscoveryPreferences ) : BOrd
        -- Submits a ddf auto discovery job and returns a BOrd to the job that is kicked off
        -- And managed by the Niagara Ax Job Service.
        flags{hidden}
        default{[new BDdfAutoDiscoveryPreferences()]}
    }

   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.BDdfCommNetwork(1871553419)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "communicator"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>communicator</code> property.
   * This component communicates on behalf of this device
   * The BValues for this property must implement BIDdfCommunicator
   * @see com.tridium.ddf.BDdfCommNetwork#getCommunicator
   * @see com.tridium.ddf.BDdfCommNetwork#setCommunicator
   */
  public static final Property communicator = newProperty(0, new BDdfCommunicator(),null);
  
  /**
   * Get the <code>communicator</code> property.
   * @see com.tridium.ddf.BDdfCommNetwork#communicator
   */
  public BValue getCommunicator() { return get(communicator); }
  
  /**
   * Set the <code>communicator</code> property.
   * @see com.tridium.ddf.BDdfCommNetwork#communicator
   */
  public void setCommunicator(BValue v) { set(communicator,v,null); }

////////////////////////////////////////////////////////////////
// Property "discoveryPreferences"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>discoveryPreferences</code> property.
   * This saves the last set of discovery preferences that
   * the user provided. Descendants should re-define this
   * property and provide a custom default Value whose class extends BDdfAutoDiscoveryPreferences.
   * @see com.tridium.ddf.BDdfCommNetwork#getDiscoveryPreferences
   * @see com.tridium.ddf.BDdfCommNetwork#setDiscoveryPreferences
   */
  public static final Property discoveryPreferences = newProperty(0, new BDdfAutoDiscoveryPreferences(),null);
  
  /**
   * Get the <code>discoveryPreferences</code> property.
   * @see com.tridium.ddf.BDdfCommNetwork#discoveryPreferences
   */
  public BDdfDiscoveryPreferences getDiscoveryPreferences() { return (BDdfDiscoveryPreferences)get(discoveryPreferences); }
  
  /**
   * Set the <code>discoveryPreferences</code> property.
   * @see com.tridium.ddf.BDdfCommNetwork#discoveryPreferences
   */
  public void setDiscoveryPreferences(BDdfDiscoveryPreferences v) { set(discoveryPreferences,v,null); }

////////////////////////////////////////////////////////////////
// Action "submitDiscoveryJob"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>submitDiscoveryJob</code> action.
   * Submits a ddf auto discovery job and returns a BOrd
   * to the job that is kicked off And managed by the Niagara
   * Ax Job Service.
   * @see com.tridium.ddf.BDdfCommNetwork#submitDiscoveryJob()
   */
  public static final Action submitDiscoveryJob = newAction(Flags.HIDDEN,new BDdfAutoDiscoveryPreferences(),null);
  
  /**
   * Invoke the <code>submitDiscoveryJob</code> action.
   * @see com.tridium.ddf.BDdfCommNetwork#submitDiscoveryJob
   */
  public BOrd submitDiscoveryJob(BDdfAutoDiscoveryPreferences preferences) { return (BOrd)invoke(submitDiscoveryJob,preferences,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfCommNetwork.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  public void started() throws Exception
  {
    wasCommEnabled=isCommEnabled();
    super.started();
  }
  
  /**
   * Uses the value of property deviceDiscoveryParams as the default parameter
   * for the submitDeviceDiscoveryJob action.
   */
  public BValue getActionParameterDefault(Action action)
  {
    if (action.equals(submitDiscoveryJob))
      return getDiscoveryPreferences();
    else
      return super.getActionParameterDefault(action);
  }
  
  /**
   * Monitors the 'status' property and stops driver i/o
   * if the 'status' is disabled or fault. Starts driver
   * i/o if the 'status' was disabled and/or fault but is
   * no longer disabled or fault.
   */
  public void changed(Property property, Context context)
  {
    if (isRunning())
    {
      if (property.equals(status))
      {
        boolean isCommEnabled = isCommEnabled();
        try
        {
          if (wasCommEnabled)
          {
            if (isCommEnabled)
            {
              // wasCommEnabled = true and also isCommEnabled = true,
              // communication is already enabled so let's do nothing
            }
            else
            {
              // wasCommEnabled = true but now isCommEnabled = false
              // let's stop communications
              disableComm();
            }
          }
          else 
          {
            if (isCommEnabled)
            {
              // wasStartable = false but now isStartable = true
              // let's start this and all descendants
              enableComm();
            }
            //else
            //{
                // wasStartable = false yet isStartable = false also
                // we cannot start this or any descenadants under this
                // scenario.
            //}
          }
        }
        finally
        {
          wasCommEnabled = isCommEnabled;
        }
      }
    }
    super.changed(property, context);
  }
  
////////////////////////////////////////////////////////////////
// BIDdfCommunicating
////////////////////////////////////////////////////////////////

  /**
   * Returns the current value of the 'communicator' property
   * cast as BIDdfCommunicator.
   */
  public BIDdfCommunicator getDdfCommunicator()
  {
    return (BIDdfCommunicator)getCommunicator();
  }
  
////////////////////////////////////////////////////////////////
// BIDdfDiscoveryHost
////////////////////////////////////////////////////////////////
  
  /**
   * Returns null by default (unless a developer overrides this) so that
   * discovery objects are stored transiently under the auto discovery
   * job.
   */
  public BFolder getDiscoveryFolder()
  {
    return null;
  }
  
////////////////////////////////////////////////////////////////
// BDeviceNetwork
////////////////////////////////////////////////////////////////
  
  public Type getDeviceFolderType()
  {
    // TODO Auto-generated method stub
    return null;
  }

  public Type getDeviceType()
  {
    // TODO Auto-generated method stub
    return null;
  }
  
////////////////////////////////////////////////////////////////
// BDdfCommNetwork
////////////////////////////////////////////////////////////////

  /**
   * Implements the 'submitDiscoveryJob' action on the station-side.
   * 
   * Kicks off a BDdfAutoDiscoveryJob and passes it the BDdfAutoDiscoveryPreferences
   * that were passed to this method. This is a copy of the information that
   * the user provides when he or she clicks the 'Discover' button from the
   * Ddf Device Nanager.
   */
  public BOrd doSubmitDiscoveryJob(BDdfAutoDiscoveryPreferences preferences)
  {
    setDiscoveryPreferences((BDdfAutoDiscoveryPreferences)preferences.newCopy()); // Saves the most recent device discovery parameters
    // Instantiates an instance of BDdfAutoDiscoveryJob passing it a reference to this network
    BDdfAutoDiscoveryJob ddfDeviceDiscoveryJob = new BDdfAutoDiscoveryJob(this);
    // Passes the discovery parameters to the job
    ddfDeviceDiscoveryJob.setDiscoveryPreferences((BDdfAutoDiscoveryPreferences)preferences.newCopy());
    // Submits the job and returns the Ord to the job as a child under the job service
    return ddfDeviceDiscoveryJob.submit(DEV_NETWORK_DISCOVER_ACTION);
  }

  /**
   * Determines whether the communicator and background processor
   * can be started.
   * 
   * @return true if neither fatalFault nor disabled
   */
  protected boolean isCommEnabled()
  {
    return ! (isFault() || isDisabled());
  }
  
  /**
   * This method is called from the 'changed' method if the status
   * changes away from fault and disabled.
   */
  protected void enableComm()
  {
    getDdfCommunicator().startCommunicating();
  }
  
  /**
   * This method is called from the 'changed' method if the status
   * changes to fault or disabled.
   */
  protected void disableComm()
  {
    getDdfCommunicator().stopCommunicating();
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  // The following variable helps the 'changed' method stop and possibly
  // restart driver communications if this object is disabled or goes to
  // fault
  boolean wasCommEnabled = false;

  /**
   * The 'doSubmitDiscoveryJob' method uses this context to submit the 
   * BDdfAutoDiscoveryJob for the device discovery.
   */
  public static final Context DEV_NETWORK_DISCOVER_ACTION = new BasicContext();
}
