/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control.util;

import javax.baja.sys.BRelTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BStringOverride is the override argument for StringWritable.
 *
 * @author    Brian Frank
 * @creation  21 Jun 04
 * @version   $Revision: 1$ $Date: 6/22/04 8:35:24 AM EDT$
 * @since     Baja 1.0
 */
public class BStringOverride
  extends BOverride
{

  /*-

  class BStringOverride
  {
    properties
    {
      value: String
        -- Value of the override.
        default {[ "" ]}
    }

  }
 -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.util.BStringOverride(3901305548)1.0$ @*/
/* Generated Mon Jun 21 20:13:15 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>value</code> property.
   * Value of the override.
   * @see javax.baja.control.util.BStringOverride#getValue
   * @see javax.baja.control.util.BStringOverride#setValue
   */
  public static final Property value = newProperty(0, "",null);
  
  /**
   * Get the <code>value</code> property.
   * @see javax.baja.control.util.BStringOverride#value
   */
  public String getValue() { return getString(value); }
  
  /**
   * Set the <code>value</code> property.
   * @see javax.baja.control.util.BStringOverride#value
   */
  public void setValue(String v) { setString(value,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStringOverride.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStringOverride(BRelTime duration, String value)
  {                                         
    setDuration(duration);
    setValue(value);
  }
  
  public BStringOverride(String value)
  {                                   
    setValue(value);
  }

  public BStringOverride()
  {
  }

}
